/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.downloader.ext;

import cn.acyou.leo.framework.downloader.ext.AbstractDownloadProgressMonitorResponseExtractor;
import cn.acyou.leo.framework.downloader.support.DownloadProgressPrinter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.springframework.http.client.ClientHttpResponse;

public class FileResponseExtractor
extends AbstractDownloadProgressMonitorResponseExtractor<File> {
    private long byteCount;
    private String filePath;
    private int index;

    public FileResponseExtractor(int index, String filePath, DownloadProgressPrinter downloadProgressPrinter) {
        super(downloadProgressPrinter);
        this.index = index;
        this.filePath = filePath;
    }

    public FileResponseExtractor(String filePath, DownloadProgressPrinter downloadProgressPrinter) {
        this(0, filePath, downloadProgressPrinter);
    }

    @Override
    protected File doExtractData(ClientHttpResponse response) throws IOException {
        int bytesRead;
        InputStream in = response.getBody();
        File file = new File(this.filePath);
        FileOutputStream out = new FileOutputStream(file);
        byte[] buffer = new byte[4096];
        while ((bytesRead = in.read(buffer)) != -1) {
            out.write(buffer, 0, bytesRead);
            this.byteCount += (long)bytesRead;
        }
        out.flush();
        out.close();
        return file;
    }

    @Override
    public long getAlreadyDownloadLength() {
        return this.byteCount;
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    protected String getTask() {
        return String.valueOf(this.getIndex());
    }
}

