/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.downloader.support;

import cn.acyou.leo.framework.downloader.support.DownloadProgressPrinter;
import java.util.Arrays;
import java.util.Objects;

public class MultiThreadDownloadProgressPrinter
implements DownloadProgressPrinter {
    private PartProgress[] partProgresses;
    private long contentLength;

    public MultiThreadDownloadProgressPrinter(int threadNum) {
        this.partProgresses = new PartProgress[threadNum];
    }

    @Override
    public void print(String indexText, long contentLength, long alreadyDownloadLength, long speed) {
        PartProgress partProgress = this.getPartProgress(indexText);
        partProgress.setAlreadyDownloadLength(alreadyDownloadLength);
    }

    private PartProgress getPartProgress(String indexText) {
        PartProgress partProgress = this.partProgresses[Integer.valueOf(indexText)];
        if (Objects.nonNull(partProgress)) {
            return partProgress;
        }
        this.partProgresses[Integer.valueOf((String)indexText).intValue()] = partProgress = new PartProgress();
        return partProgress;
    }

    @Override
    public long setContentLength(long contentLength) {
        this.contentLength = contentLength;
        return this.contentLength;
    }

    @Override
    public long getContentLength() {
        return this.contentLength;
    }

    @Override
    public long getAlreadyDownloadLength() {
        return Arrays.stream(this.partProgresses).filter(Objects::nonNull).map(PartProgress::getAlreadyDownloadLength).reduce(Long::sum).orElse(0L);
    }

    static class PartProgress {
        long alreadyDownloadLength;

        PartProgress() {
        }

        public void setAlreadyDownloadLength(long alreadyDownloadLength) {
            this.alreadyDownloadLength = alreadyDownloadLength;
        }

        public long getAlreadyDownloadLength() {
            return this.alreadyDownloadLength;
        }
    }
}

