/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.mybatis;

import cn.acyou.leo.framework.base.BaseEntity;
import cn.acyou.leo.framework.context.AppContext;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;

@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class})})
public class BaseEntityInterceptor
implements Interceptor {
    private static final String COLLECTION_KEY = "collection";

    public Object intercept(Invocation invocation) throws Throwable {
        MappedStatement mappedStatement = (MappedStatement)invocation.getArgs()[0];
        if (invocation.getArgs().length > 1) {
            Object parameterObject = invocation.getArgs()[1];
            if (parameterObject instanceof Map) {
                Map paramMap = (Map)parameterObject;
                if (paramMap.containsKey(COLLECTION_KEY)) {
                    Collection collection = (Collection)paramMap.get(COLLECTION_KEY);
                    for (Object obj : collection) {
                        this.handlerBaseField(mappedStatement, obj);
                    }
                }
            } else {
                this.handlerBaseField(mappedStatement, parameterObject);
            }
        }
        return invocation.proceed();
    }

    private void handlerBaseField(MappedStatement mappedStatement, Object parameterObject) {
        if (parameterObject instanceof BaseEntity) {
            BaseEntity baseEntity = (BaseEntity)parameterObject;
            if (SqlCommandType.INSERT == mappedStatement.getSqlCommandType()) {
                if (baseEntity.getCreateUser() == null) {
                    baseEntity.setCreateUser(AppContext.getUserId());
                }
                if (baseEntity.getCreateTime() == null) {
                    baseEntity.setCreateTime(new Date());
                }
                if (baseEntity.getUpdateUser() == null) {
                    baseEntity.setUpdateUser(baseEntity.getCreateUser());
                }
                if (baseEntity.getUpdateTime() == null) {
                    baseEntity.setUpdateTime(new Date());
                }
            }
            if (SqlCommandType.UPDATE == mappedStatement.getSqlCommandType()) {
                if (baseEntity.getUpdateUser() == null) {
                    baseEntity.setUpdateUser(AppContext.getUserId());
                }
                if (baseEntity.getUpdateTime() == null) {
                    baseEntity.setUpdateTime(new Date());
                }
            }
        }
    }

    public Object plugin(Object target) {
        if (target instanceof Executor) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public void setProperties(Properties properties) {
    }
}

