/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.thread;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import org.slf4j.MDC;

class MdcHelper {
    MdcHelper() {
    }

    public static Map<String, String> getContextForTask() {
        return MDC.getCopyOfContextMap();
    }

    private static void setTraceIdIfAbsent() {
        if (MDC.get((String)"leoTraceNo") == null) {
            MDC.put((String)"leoTraceNo", (String)UUID.randomUUID().toString().replaceAll("-", ""));
        }
    }

    public static <T> Callable<T> wrap(Callable<T> task, Map<String, String> context) {
        return () -> {
            if (context != null && !context.isEmpty()) {
                MDC.setContextMap((Map)context);
            }
            try {
                MdcHelper.setTraceIdIfAbsent();
                Object v = task.call();
                return v;
            }
            finally {
                if (context != null && !context.isEmpty()) {
                    MDC.clear();
                }
            }
        };
    }

    public static Runnable wrap(Runnable runnable, Map<String, String> context) {
        return () -> {
            if (context != null && !context.isEmpty()) {
                MDC.setContextMap((Map)context);
            }
            try {
                MdcHelper.setTraceIdIfAbsent();
                runnable.run();
            }
            finally {
                if (context != null && !context.isEmpty()) {
                    MDC.clear();
                }
            }
        };
    }
}

