/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.util;

import io.swagger.annotations.ApiModelProperty;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cglib.beans.BeanMap;
import org.springframework.objenesis.instantiator.util.ClassUtils;

public class BeanUtil {
    private static final Logger log = LoggerFactory.getLogger(BeanUtil.class);

    public static Map<String, Object> convertToMap(Object obj) {
        return BeanUtil.beanToMap(obj);
    }

    public static Map<String, Object> beanToMap(Object bean) {
        return null == bean ? null : new HashMap(BeanMap.create((Object)bean));
    }

    public static <T> T mapToBean(Map<String, ?> map, Class<T> clazz) {
        Object bean = ClassUtils.newInstance(clazz);
        BeanMap.create((Object)bean).putAll(map);
        return (T)bean;
    }

    public static Map<String, String> differentInfo(Object obj1, Object obj2) {
        LinkedHashMap<String, String> resMap = new LinkedHashMap<String, String>();
        if (!obj1.getClass().equals(obj2.getClass())) {
            return resMap;
        }
        Field[] obj1Fields = obj1.getClass().getDeclaredFields();
        Field[] obj2Fields = obj2.getClass().getDeclaredFields();
        for (Field obj1Field : obj1Fields) {
            ApiModelProperty annotation = obj1Field.getAnnotation(ApiModelProperty.class);
            String value = annotation.value();
            try {
                String o2Vstr;
                obj1Field.setAccessible(true);
                Object o1V = obj1Field.get(obj1);
                obj1Field.setAccessible(false);
                Object o2V = null;
                for (Field obj2Field : obj2Fields) {
                    if (!obj1Field.getName().equals(obj2Field.getName())) continue;
                    obj2Field.setAccessible(true);
                    o2V = obj2Field.get(obj2);
                    obj2Field.setAccessible(false);
                    break;
                }
                String o1Vstr = o1V == null ? "" : o1V.toString();
                String string = o2Vstr = o2V == null ? "" : o2V.toString();
                if (o1Vstr.equals(o2Vstr)) continue;
                String desc = o1Vstr + " -> " + o2Vstr;
                resMap.put(value, desc);
            }
            catch (IllegalAccessException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return resMap;
    }
}

