/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.util;

import cn.acyou.leo.framework.base.LoginUser;
import cn.acyou.leo.framework.base.OrganizationVo;
import cn.acyou.leo.framework.context.AppContext;
import cn.acyou.leo.framework.exception.DataPermissionDeniedException;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class DataScopeUtil {
    public static String scopeSql() {
        return DataScopeUtil.scopeSql("");
    }

    public static String scopeSql(String alias) {
        String scopeSql = "";
        LoginUser loginUser = AppContext.getLoginUser();
        if (loginUser == null) {
            throw new DataPermissionDeniedException("\u60a8\u6ca1\u6709\u67e5\u770b\u6570\u636e\u7684\u6743\u9650\uff0c\u8bf7\u5148\u767b\u5f55\uff01");
        }
        Set<String> roleCodes = loginUser.getRoleCodes();
        if (roleCodes == null || roleCodes.isEmpty()) {
            throw new DataPermissionDeniedException("\u60a8\u6ca1\u6709\u67e5\u770b\u6570\u636e\u7684\u6743\u9650\uff0c\u8bf7\u5148\u6dfb\u52a0\u89d2\u8272\uff01");
        }
        String actionUrl = AppContext.getActionUrl();
        int dataScope = loginUser.getRoleVo().getDataScope();
        String dataScopeCustomField = "";
        Long orgId = null;
        OrganizationVo organization = loginUser.getOrganization();
        if (organization != null) {
            orgId = organization.getOrgId();
        }
        StringBuilder sqlString = new StringBuilder();
        switch (dataScope) {
            case 10: {
                break;
            }
            case 15: {
                StringBuilder scopeDeptSubSql = new StringBuilder();
                if (StringUtils.isNotEmpty((CharSequence)alias)) {
                    scopeDeptSubSql.append(alias).append(".");
                }
                if (orgId == null) {
                    throw new DataPermissionDeniedException("\u60a8\u6ca1\u6709\u67e5\u770b\u6570\u636e\u7684\u6743\u9650\uff0c\u8bf7\u5148\u6dfb\u52a0\u79d1\u5ba4\uff01");
                }
                List<Long> subOrgIds = organization.getSubOrgIds();
                scopeDeptSubSql.append("org_id in ( ").append(StringUtils.join(subOrgIds, (String)",")).append(")");
                sqlString.append((CharSequence)scopeDeptSubSql);
                break;
            }
            case 20: {
                StringBuilder scopeDeptSql = new StringBuilder();
                if (StringUtils.isNotEmpty((CharSequence)alias)) {
                    scopeDeptSql.append(alias).append(".");
                }
                if (orgId == null) {
                    throw new DataPermissionDeniedException("\u60a8\u6ca1\u6709\u67e5\u770b\u6570\u636e\u7684\u6743\u9650\uff0c\u8bf7\u5148\u6dfb\u52a0\u79d1\u5ba4\uff01");
                }
                scopeDeptSql.append("org_id = '").append(orgId).append("'");
                sqlString.append((CharSequence)scopeDeptSql);
                break;
            }
            case 30: {
                StringBuilder scopeOwnSql = new StringBuilder();
                if (StringUtils.isNotEmpty((CharSequence)alias)) {
                    scopeOwnSql.append(alias).append(".");
                }
                scopeOwnSql.append("create_user = ").append(loginUser.getUserId());
                sqlString.append((CharSequence)scopeOwnSql);
                break;
            }
        }
        if (StringUtils.isNotBlank((CharSequence)sqlString.toString())) {
            scopeSql = " AND (" + sqlString + ")";
        }
        return scopeSql;
    }
}

