/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.util;

import cn.acyou.leo.framework.util.UrlUtil;
import java.util.Map;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class HttpUtil2 {
    public static final RestTemplate restTemplate = new RestTemplate();

    private HttpUtil2() {
    }

    public static String get(String url) {
        return HttpUtil2.get(url, null, null);
    }

    public static String getParameter(String url, Map<String, Object> paramsMap) {
        return HttpUtil2.get(url, paramsMap, null);
    }

    public static String getHeader(String url, Map<String, String> headersMap) {
        return HttpUtil2.get(url, null, headersMap);
    }

    public static String get(String url, Map<String, Object> paramsMap, Map<String, String> headersMap) {
        return HttpUtil2.get(url, paramsMap, headersMap, String.class);
    }

    public static <T> T get(String url, Map<String, Object> paramsMap, Map<String, String> headersMap, Class<T> resType) {
        return HttpUtil2.getMethod(url, paramsMap, headersMap, resType, null);
    }

    public static <T> T get(String url, Map<String, Object> paramsMap, Map<String, String> headersMap, ParameterizedTypeReference<T> responseType) {
        return HttpUtil2.getMethod(url, paramsMap, headersMap, null, responseType);
    }

    private static <T> T getMethod(String url, Map<String, Object> paramsMap, Map<String, String> headersMap, Class<T> resType, ParameterizedTypeReference<T> responseType) {
        HttpHeaders headers = new HttpHeaders();
        if (headersMap != null && !headersMap.isEmpty()) {
            headersMap.forEach((arg_0, arg_1) -> ((HttpHeaders)headers).add(arg_0, arg_1));
        }
        if (paramsMap != null && !paramsMap.isEmpty()) {
            url = UrlUtil.append(url, paramsMap);
        }
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        if (resType != null) {
            ResponseEntity result = restTemplate.exchange(url, HttpMethod.GET, entity, resType, new Object[0]);
            return (T)result.getBody();
        }
        if (responseType != null) {
            ResponseEntity result = restTemplate.exchange(url, HttpMethod.GET, entity, responseType, new Object[0]);
            return (T)result.getBody();
        }
        return null;
    }

    public static <T> T post(String url, Map<String, Object> paramsMap, Map<String, String> headersMap, Class<T> resType) {
        return HttpUtil2.postMethod(url, paramsMap, headersMap, resType, null);
    }

    public static <T> T post(String url, Map<String, Object> paramsMap, Map<String, String> headersMap, ParameterizedTypeReference<T> responseType) {
        return HttpUtil2.postMethod(url, paramsMap, headersMap, null, responseType);
    }

    private static <T> T postMethod(String url, Map<String, Object> paramsMap, Map<String, String> headersMap, Class<T> resType, ParameterizedTypeReference<T> responseType) {
        ResponseEntity result;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        if (headersMap != null && !headersMap.isEmpty()) {
            headersMap.forEach((arg_0, arg_1) -> ((HttpHeaders)headers).add(arg_0, arg_1));
        }
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        if (paramsMap != null && !paramsMap.isEmpty()) {
            for (Map.Entry<String, Object> param : paramsMap.entrySet()) {
                map.add((Object)param.getKey(), (Object)param.getValue().toString());
            }
        }
        HttpEntity entity = new HttpEntity((Object)map, (MultiValueMap)headers);
        if (resType != null) {
            result = restTemplate.exchange(url, HttpMethod.POST, entity, resType, new Object[0]);
            return (T)result.getBody();
        }
        if (responseType != null) {
            result = restTemplate.exchange(url, HttpMethod.POST, entity, responseType, new Object[0]);
            return (T)result.getBody();
        }
        return null;
    }

    public static <T> T postJson(String url, String jsonParamStr, Map<String, String> headersMap, Class<T> resType) {
        return HttpUtil2.postJsonMethod(url, jsonParamStr, headersMap, resType, null);
    }

    public static <T> T postJson(String url, String jsonParamStr, Map<String, String> headersMap, ParameterizedTypeReference<T> responseType) {
        return HttpUtil2.postJsonMethod(url, jsonParamStr, headersMap, null, responseType);
    }

    private static <T> T postJsonMethod(String url, String jsonParamStr, Map<String, String> headersMap, Class<T> resType, ParameterizedTypeReference<T> responseType) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        if (headersMap != null && !headersMap.isEmpty()) {
            headersMap.forEach((arg_0, arg_1) -> ((HttpHeaders)headers).add(arg_0, arg_1));
        }
        HttpEntity entity = new HttpEntity((Object)jsonParamStr, (MultiValueMap)headers);
        if (resType != null) {
            ResponseEntity result = restTemplate.exchange(url, HttpMethod.POST, entity, resType, new Object[0]);
            return (T)result.getBody();
        }
        if (responseType != null) {
            ResponseEntity result = restTemplate.exchange(url, HttpMethod.POST, entity, responseType, new Object[0]);
            return (T)result.getBody();
        }
        return null;
    }
}

