/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.springframework.util.ReflectionUtils;

public class ReflectUtils
extends ReflectionUtils {
    public static Field recursiveFieldFinder(Class<?> annotatedClass, Class<? extends Annotation> annotationClass) {
        ArrayList fieldList = new ArrayList();
        ReflectUtils.doWithFields(annotatedClass, fieldList::add, f -> f.isAnnotationPresent(annotationClass));
        if (!fieldList.isEmpty()) {
            return (Field)fieldList.get(0);
        }
        return null;
    }

    public static Field getField(String fieldName, Class<?> clazz) {
        return ReflectUtils.findField(clazz, (String)fieldName);
    }

    public static Field getField(String fieldName, String className) {
        try {
            return ReflectUtils.getField(fieldName, Class.forName(className));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Field getField(String fieldName, Object object) {
        return ReflectUtils.getField(fieldName, object.getClass());
    }

    public static List<Field> getFields(Class<?> clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        ReflectionUtils.doWithFields(clazz, fields::add);
        return fields;
    }

    public static void setFieldValue(String fieldName, Object object, Object value) {
        Field field = ReflectUtils.getField(fieldName, object.getClass());
        ReflectUtils.setFieldValue(field, object, value);
    }

    public static void setFieldValue(Field field, Object object, Object value) {
        ReflectionUtils.makeAccessible((Field)field);
        ReflectionUtils.setField((Field)field, (Object)object, (Object)value);
    }

    public static Object getFieldValue(Object object, String fieldName) {
        Field field = ReflectUtils.getField(fieldName, object.getClass());
        return ReflectUtils.getFieldValue(object, field);
    }

    public static Object getFieldValue(Object object, Field field) {
        ReflectionUtils.makeAccessible((Field)field);
        return ReflectionUtils.getField((Field)field, (Object)object);
    }

    public static void setValueBySetMethod(String fieldName, Object object, Object value) {
        if (object == null) {
            throw new RuntimeException("\u5b9e\u4f8b\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (value == null) {
            return;
        }
        try {
            String setMethodName = "set" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
            Method setMethod = ReflectUtils.getMethod(setMethodName, object.getClass(), value.getClass());
            setMethod.invoke(object, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static void setValueBySetMethod(Field field, Object object, Object value) {
        if (object == null) {
            throw new RuntimeException("\u5b9e\u4f8b\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (value == null) {
            return;
        }
        ReflectUtils.setValueBySetMethod(field.getName(), object, value);
    }

    public static <T> T getValueByGetMethod(String fieldName, Object object) {
        try {
            if (fieldName != null && fieldName.trim().length() > 0) {
                String getMethodName = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                Method getMethod = ReflectUtils.getMethod(getMethodName, object.getClass());
                return (T)getMethod.invoke(object, new Object[0]);
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static <T> T getValueByGetMethod(Field field, Object object) {
        return ReflectUtils.getValueByGetMethod(field.getName(), object);
    }

    public static Method getMethod(String methodName, Class<?> clazz) {
        return ReflectUtils.findMethod(clazz, (String)methodName);
    }

    public static String getMethodName(String fieldName) {
        return "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
    }

    public static Method getMethod(String methodName, Class<?> clazz, Class<?> paramType) {
        return ReflectUtils.findMethod(clazz, (String)methodName, (Class[])new Class[]{paramType});
    }

    public static Method getMethod(String methodName, Object obj) {
        return ReflectUtils.getMethod(methodName, obj.getClass());
    }

    public static Method getMethod(String methodName, Object obj, Class<?> paramType) {
        return ReflectUtils.getMethod(methodName, obj.getClass(), paramType);
    }

    public static Method getMethod(String methodName, String clazz) {
        try {
            return ReflectUtils.getMethod(methodName, Class.forName(clazz));
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static Method getMethod(String methodName, String clazz, Class<?> paramType) {
        try {
            return ReflectUtils.getMethod(methodName, Class.forName(clazz), paramType);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static Annotation getMethodAnnotation(Method method, Class targetAnnotationClass) {
        return method.getAnnotation(targetAnnotationClass);
    }

    public static Annotation getFieldAnnotation(Field field, Class targetAnnotationClass) {
        return field.getAnnotation(targetAnnotationClass);
    }

    public static Annotation getClassAnnotation(Class targetAnnotationClass, Class<?> targetObjcetClass) {
        Object methodAnnotation = targetObjcetClass.getAnnotation(targetAnnotationClass);
        return methodAnnotation;
    }

    public static Annotation getClassAnnotation(Class targetAnnotationClass, Object obj) {
        return ReflectUtils.getClassAnnotation(targetAnnotationClass, obj.getClass());
    }

    public static Annotation getClassAnnotation(Class targetAnnotationClass, String clazz) {
        try {
            return ReflectUtils.getClassAnnotation(targetAnnotationClass, Class.forName(clazz));
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static <T> T getAnnotationValue(String methodName, Annotation annotation) {
        try {
            Method method = annotation.annotationType().getMethod(methodName, new Class[0]);
            Object object = method.invoke((Object)annotation, new Object[0]);
            return (T)object;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static <T> T getMethodAnnotationValue(String methodName, Class targetAnnotationClass, String targetObjecMethodName, Class targetObjectClass) {
        Method method = ReflectUtils.getMethod(targetObjecMethodName, targetObjectClass);
        Annotation annotation = ReflectUtils.getMethodAnnotation(method, targetAnnotationClass);
        return ReflectUtils.getAnnotationValue(methodName, annotation);
    }

    public static <T> T getFieldAnnotationValue(String methodName, Class targetAnnotationClass, String targetObjecFieldName, Class targetObjectClass) {
        Field field = ReflectUtils.getField(targetObjecFieldName, targetObjectClass);
        Annotation annotation = ReflectUtils.getFieldAnnotation(field, targetAnnotationClass);
        return ReflectUtils.getAnnotationValue(methodName, annotation);
    }
}

