/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.util;

import cn.acyou.leo.framework.util.RegexUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class StringUtils
extends org.springframework.util.StringUtils {
    public static final String SPACE = " ";
    public static final String EMPTY = "";
    public static final String COMMA = ",";
    public static final String DOT = ".";
    public static final String NEW_LINE = "\r\n";

    public static String concatLengthChar(int length, char character) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            sb.append(character);
        }
        return sb.toString();
    }

    public static String joinOnComma(Iterable<?> iterable) {
        return org.apache.commons.lang3.StringUtils.join(iterable.iterator(), (String)COMMA);
    }

    public static String formatTemplate(String templateStr, Map<String, String> paramsMap) {
        String templateContent = templateStr;
        Set<Map.Entry<String, String>> entrySet = paramsMap.entrySet();
        for (Map.Entry<String, String> entry : entrySet) {
            if (entry.getValue() == null || templateContent.indexOf(entry.getKey()) <= 0) continue;
            templateContent = templateContent.replace("{" + entry.getKey() + "}", entry.getValue());
        }
        return templateContent;
    }

    public static String toStr(Object obj) {
        String str = EMPTY;
        if (obj != null) {
            str = obj.toString();
        }
        return str;
    }

    public static String nullAsDashed(String str) {
        if (str == null) {
            return "-";
        }
        return str;
    }

    public static String isBlank(Object value, Object defaultValue) {
        if (StringUtils.isBlank(value)) {
            return defaultValue.toString();
        }
        return value.toString();
    }

    public static boolean isBlank(String str) {
        return !StringUtils.hasText((String)str);
    }

    public static boolean isNotBlank(String str) {
        return StringUtils.hasText((String)str);
    }

    public static boolean isNotBlank(Object obj) {
        return obj != null && StringUtils.isNotBlank(obj.toString());
    }

    public static String isNotBlank(Object obj, Object defaultValue) {
        return StringUtils.isNotBlank(obj) ? obj.toString() : defaultValue.toString();
    }

    public static boolean isBlank(Object obj) {
        return obj == null || StringUtils.isBlank(obj.toString());
    }

    public static String[] strLengthSplit(String sourceStr, int length) {
        if (StringUtils.isBlank(sourceStr)) {
            return new String[]{EMPTY, EMPTY};
        }
        int sp = length * 2;
        int indexCount = 0;
        int index = 0;
        char[] chars = sourceStr.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            indexCount = RegexUtil.isChinese(c) ? (indexCount += 2) : ++indexCount;
            if (indexCount <= sp) continue;
            index = i;
            break;
        }
        String[] returnStr = new String[]{EMPTY, EMPTY};
        if (index > 0) {
            returnStr[0] = sourceStr.substring(0, index);
            returnStr[1] = sourceStr.substring(index);
        } else {
            returnStr[0] = sourceStr;
            returnStr[1] = EMPTY;
        }
        return returnStr;
    }

    public static boolean isHttpUrl(String text) {
        return text.startsWith("http://") || text.startsWith("https://");
    }

    public static String hide(CharSequence str, int startInclude, int endExclude) {
        return StringUtils.replace(str, startInclude, endExclude, '*');
    }

    public static String replace(CharSequence str, int startInclude, int endExclude, char replacedChar) {
        if (str == null || str.length() == 0) {
            return StringUtils.str(str);
        }
        int strLength = str.length();
        if (startInclude > strLength) {
            return StringUtils.str(str);
        }
        if (endExclude > strLength) {
            endExclude = strLength;
        }
        if (startInclude > endExclude) {
            return StringUtils.str(str);
        }
        char[] chars = new char[strLength];
        for (int i = 0; i < strLength; ++i) {
            chars[i] = i >= startInclude && i < endExclude ? replacedChar : str.charAt(i);
        }
        return new String(chars);
    }

    public static String str(CharSequence cs) {
        return null == cs ? null : cs.toString();
    }

    public static List<String> splitByLength(String sourStr, int length) {
        return StringUtils.splitByLength(new ArrayList<String>(), sourStr, length);
    }

    private static List<String> splitByLength(List<String> container, String sourStr, int length) {
        if (sourStr != null && sourStr.length() > 0) {
            if (sourStr.length() < length) {
                container.add(sourStr);
                return container;
            }
            String str0 = sourStr.substring(0, length);
            String str1 = sourStr.substring(length);
            container.add(str0);
            return StringUtils.splitByLength(container, str1, length);
        }
        return container;
    }

    public static void println(Object obj) {
        if (obj == null) {
            System.out.println("null");
            return;
        }
        if (obj instanceof CharSequence) {
            System.out.println(obj);
            return;
        }
        if (obj.getClass().isArray()) {
            Arrays.stream((Object[])obj).forEach(System.out::println);
            return;
        }
        if (obj instanceof Collection) {
            ((Collection)obj).forEach(System.out::println);
            return;
        }
        if (obj instanceof Map) {
            ((Map)obj).forEach((k, v) -> System.out.println(k + ":" + v));
            return;
        }
        System.out.println(obj);
    }

    public static void main(String[] args) {
        String templateStr = "{\u59d3\u540d}\u4eca\u5e74{\u5c81}\u5566\uff01";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("\u59d3\u540d", "\u738b\u4e8c\u5c0f");
        paramMap.put("\u5c81", "3");
        System.out.println(StringUtils.formatTemplate(templateStr, paramMap));
    }
}

