/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.util;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class UrlUtil {
    private static final Logger log = LoggerFactory.getLogger(UrlUtil.class);

    public static boolean isUrl(String url) {
        try {
            new URL(url);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean startWithHttp(String url) {
        return url != null && (url.startsWith("http") || url.startsWith("https"));
    }

    public static String getQueryString(String url, String key) {
        Map<String, String> paramsMap = UrlUtil.getQueryString(url);
        return paramsMap.get(key) != null ? paramsMap.get(key) : "";
    }

    public static String getJsonPJsonStr(String jsonpStr) {
        int startIndex = jsonpStr.indexOf("(");
        int endIndex = jsonpStr.lastIndexOf(")");
        return jsonpStr.substring(startIndex + 1, endIndex);
    }

    public static Map<String, String> getQueryString(String url) {
        HashMap<String, String> map = new HashMap<String, String>();
        int start = url.indexOf("?");
        if (start >= 0) {
            String[] paramsArr;
            String str = url.substring(start + 1);
            for (String param : paramsArr = str.split("&")) {
                String[] temp = param.split("=");
                if (temp.length == 1) {
                    map.put(temp[0], "");
                    continue;
                }
                map.put(temp[0], temp[1]);
            }
        }
        return map;
    }

    public static String getQueryStringFromPath(String url) {
        int start = url.lastIndexOf("/") + 1;
        if (url.lastIndexOf("?") == -1) {
            return url.substring(start);
        }
        return url.substring(start, url.lastIndexOf("?"));
    }

    public static String replaceUrlParams(String url, Map<String, String> newParams) {
        String newUrl = url;
        for (Map.Entry<String, String> entry : newParams.entrySet()) {
            Pattern pattern = Pattern.compile("([?&])" + entry.getKey() + "=([^&]+)");
            Matcher matcher = pattern.matcher(newUrl);
            if (!matcher.find()) continue;
            String group = matcher.group(0);
            if (group.startsWith("?")) {
                newUrl = matcher.replaceAll("?" + entry.getKey() + "=" + entry.getValue());
            }
            if (!group.startsWith("&")) continue;
            newUrl = matcher.replaceAll("&" + entry.getKey() + "=" + entry.getValue());
        }
        return newUrl;
    }

    public static String replaceUrlParams(String url, String ... params) {
        HashMap<String, String> newParamsMap = new HashMap<String, String>();
        int length = params.length;
        if (length == 0) {
            return url;
        }
        if (length % 2 != 0) {
            throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef\uff0c\u4e0d\u80fd\u4e3a\u5947\u6570");
        }
        for (int i = 0; i < params.length; i += 2) {
            newParamsMap.put(params[i], params[i + 1]);
        }
        return UrlUtil.replaceUrlParams(url, newParamsMap);
    }

    public static String append(String url, String ... params) {
        ArrayList<String> paramList = new ArrayList<String>();
        int length = params.length;
        if (length == 0) {
            return url;
        }
        if (length % 2 != 0) {
            throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef\uff0c\u4e0d\u80fd\u4e3a\u5947\u6570");
        }
        for (int i = 0; i < params.length; i += 2) {
            paramList.add("&" + params[i] + "=" + params[i + 1]);
        }
        if (url.endsWith("&")) {
            url = url.substring(0, url.length() - 1);
        }
        if (!url.contains("?")) {
            url = url.concat("?");
        }
        return url + StringUtils.join(paramList, (String)"");
    }

    public static String append(String url, Map<String, ?> params) {
        for (Map.Entry<String, ?> entry : params.entrySet()) {
            url = UrlUtil.append(url, entry.getKey(), entry.getValue().toString());
        }
        return url;
    }

    public static String getHost(String url) {
        try {
            URL url1 = new URL(url);
            return url1.getHost();
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String getProtocolHost(String url) {
        try {
            URL url1 = new URL(url);
            return url1.getProtocol() + "://" + url1.getHost();
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String getPathName(String url) {
        try {
            URL url1 = new URL(url);
            return url1.getPath();
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String getExtension(String url) {
        try {
            URL realUrl = new URL(url);
            String path = realUrl.getPath();
            if (path.contains(".")) {
                return path.substring(path.lastIndexOf(".") + 1);
            }
        }
        catch (Exception e) {
            return "";
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getContentLength(URL url) {
        if (null == url) {
            return -1L;
        }
        URLConnection conn = null;
        try {
            conn = url.openConnection();
            long l = conn.getContentLengthLong();
            return l;
        }
        catch (IOException e) {
            long l = -1L;
            return l;
        }
        finally {
            if (conn instanceof HttpURLConnection) {
                ((HttpURLConnection)conn).disconnect();
            }
        }
    }

    public static String getName(String url) {
        try {
            URL url1 = new URL(url);
            return url1.getPath().substring(url1.getPath().lastIndexOf("/") + 1);
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String getBaseName(String url) {
        String name = UrlUtil.getName(url);
        if (name.contains(".")) {
            return name.substring(0, name.indexOf("."));
        }
        return name;
    }

    public static String getSearch(String url) {
        try {
            URL url1 = new URL(url);
            return url1.getQuery();
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String getFile(String url) {
        try {
            URL url1 = new URL(url);
            return url1.getFile();
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String getCookieStrFromSetCookie(List<String> setCookieHeaders) {
        if (CollectionUtils.isEmpty(setCookieHeaders)) {
            return "";
        }
        ArrayList<String> cookieList = new ArrayList<String>();
        for (String setCookieHeader : setCookieHeaders) {
            String[] split = setCookieHeader.split(";");
            cookieList.add(split[0]);
        }
        return StringUtils.join(cookieList, (String)"; ");
    }

    public static String getCookieStr(Map<String, String> cookies) {
        ArrayList<String> cookieList = new ArrayList<String>();
        for (Map.Entry<String, String> cookie : cookies.entrySet()) {
            cookieList.add(cookie.getKey() + "=" + cookie.getValue());
        }
        return StringUtils.join(cookieList, (String)"; ");
    }

    public static Map<String, String> getCookieMapFromCookieStr(String cookieStr) {
        HashMap<String, String> cookieMap = new HashMap<String, String>();
        if (cookieStr != null) {
            String[] cookieElements;
            for (String cookieEle : cookieElements = cookieStr.split(";")) {
                String[] split = cookieEle.split("=");
                cookieMap.put(split[0], split[1]);
            }
        }
        return cookieMap;
    }

    public static String encode(String url) {
        try {
            return URLEncoder.encode(url, "UTF-8");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return url;
        }
    }

    public static String decode(String url) {
        try {
            return URLDecoder.decode(url, "UTF-8");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return url;
        }
    }
}

