/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.util;

import cn.acyou.leo.framework.util.function.CallTask;
import cn.acyou.leo.framework.util.function.Task;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StopWatch;

public class WorkUtil {
    private static final Logger log = LoggerFactory.getLogger(WorkUtil.class);

    public static <T> T doCallWork(long timeout, TimeUnit unit, Supplier<T> supplier) {
        long startTime = System.nanoTime();
        long rem = unit.toNanos(timeout);
        do {
            try {
                T t = supplier.get();
                if (t != null) {
                    return t;
                }
            }
            catch (Exception ex) {
                if (rem <= 0L) continue;
                try {
                    Thread.sleep(Math.min(TimeUnit.NANOSECONDS.toMillis(rem) + 1L, 100L));
                }
                catch (Exception e) {
                    log.error(e.getMessage());
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        } while ((rem = unit.toNanos(timeout) - (System.nanoTime() - startTime)) > 0L);
        return null;
    }

    public static void tryRun(Task task) {
        try {
            task.run();
        }
        catch (Exception e) {
            WorkUtil.printFirstStack(e);
        }
    }

    public static void printFirstStack(Throwable e) {
        String reason = e.getMessage();
        StackTraceElement[] stackTrace = e.getStackTrace();
        if (stackTrace != null && stackTrace.length > 0) {
            StackTraceElement stackTraceElement = stackTrace[0];
            reason = reason + " ERROR MSG: " + stackTraceElement.getClassName() + "|" + stackTraceElement.getMethodName() + ":" + stackTraceElement.getLineNumber();
        }
        log.error(reason);
    }

    public static void trySleep5000() {
        WorkUtil.trySleep(5000L);
    }

    public static void trySleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
    }

    public static <T> T doRetryWork(int times, CallTask<T> task) {
        for (int currentTime = 0; currentTime < times; ++currentTime) {
            try {
                return task.run();
            }
            catch (Exception e) {
                log.error("doRetryWorkError \u6267\u884c\u4efb\u52a1\u51fa\u9519", (Throwable)e);
                WorkUtil.trySleep(2000L);
                continue;
            }
        }
        return null;
    }

    public static void doRetryWork(int times, Task task) {
        for (int currentTime = 0; currentTime < times; ++currentTime) {
            try {
                task.run();
                return;
            }
            catch (Exception e) {
                log.error("doRetryWorkError \u6267\u884c\u4efb\u52a1\u51fa\u9519", (Throwable)e);
                WorkUtil.trySleep(2000L);
                continue;
            }
        }
    }

    public static void watch(Task task) {
        StopWatch stopWatch = new StopWatch();
        log.info("\u4efb\u52a1\u8017\u65f6\u76d1\u63a7 \u5f00\u59cb -> ...");
        stopWatch.start();
        task.run();
        stopWatch.stop();
        log.info("\u4efb\u52a1\u8017\u65f6\u76d1\u63a7 \u7ed3\u675f <- \u8017\u65f6\uff1a{}ms", (Object)stopWatch.getTotalTimeMillis());
    }
}

