/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.xss;

import cn.acyou.leo.framework.xss.XssHttpServletRequestWrapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.StringUtils;
import org.springframework.web.util.ContentCachingResponseWrapper;

public class XssFilter
implements Filter {
    public List<String> excludes = new ArrayList<String>();
    public boolean enabled = true;
    private AntPathMatcher pathMatcher = new AntPathMatcher();

    public void init(FilterConfig filterConfig) {
        String tempExcludes = filterConfig.getInitParameter("excludes");
        String tempEnabled = filterConfig.getInitParameter("enabled");
        if (StringUtils.hasText((String)tempExcludes)) {
            String[] url = tempExcludes.split(",");
            this.excludes.addAll(Arrays.asList(url));
        }
        if (StringUtils.hasText((String)tempEnabled)) {
            this.enabled = Boolean.parseBoolean(tempEnabled);
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        if (this.handleExcludeURL(req, resp)) {
            chain.doFilter(request, response);
            return;
        }
        XssHttpServletRequestWrapper xssRequest = new XssHttpServletRequestWrapper((HttpServletRequest)request);
        ContentCachingResponseWrapper responseWrapper = new ContentCachingResponseWrapper((HttpServletResponse)response);
        chain.doFilter((ServletRequest)xssRequest, (ServletResponse)responseWrapper);
        responseWrapper.copyBodyToResponse();
    }

    private boolean handleExcludeURL(HttpServletRequest request, HttpServletResponse response) {
        String requestURI = request.getRequestURI();
        if (requestURI.contains("socket")) {
            return true;
        }
        if (!this.enabled) {
            return true;
        }
        if (this.excludes == null || this.excludes.isEmpty()) {
            return false;
        }
        String url = request.getServletPath();
        for (String pattern : this.excludes) {
            if (!this.pathMatcher.match(pattern, url)) continue;
            return true;
        }
        return false;
    }

    public void destroy() {
    }
}

