/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.advisor;

import cn.acyou.leo.framework.advisor.RedisLockSource;
import cn.acyou.leo.framework.exception.ConcurrentException;
import cn.acyou.leo.framework.util.ElParser;
import cn.acyou.leo.framework.util.redis.RedisUtils;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.Ordered;

public class RedisLockInterceptor
implements MethodInterceptor,
Ordered {
    private static final Logger log = LoggerFactory.getLogger(RedisLockInterceptor.class);
    private static final String REDIS_LOCK_KEY_PREFIX = "RedisAnn_LOCK:";
    private final RedisUtils redisUtils;
    private final RedisLockSource redisLockSource;

    public RedisLockInterceptor(RedisUtils redisUtils, RedisLockSource redisLockSource) {
        this.redisUtils = redisUtils;
        this.redisLockSource = redisLockSource;
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation invocation) throws Throwable {
        Class targetClass = invocation.getThis() != null ? AopUtils.getTargetClass((Object)invocation.getThis()) : null;
        RedisLockSource.RedisLockMetadata metadata = this.redisLockSource.getRedisLockMetadata(invocation.getMethod(), targetClass);
        if (metadata != null) {
            Object result;
            String lockId = null;
            String keyValue = this.getKeyValue(invocation, targetClass, metadata.getKey());
            try {
                int waitTime = metadata.getWaitTime();
                lockId = waitTime > 0 ? this.redisUtils.lockLoop(keyValue, waitTime, metadata.getExpire()) : this.redisUtils.lock(keyValue, metadata.getExpire());
                log.info("RedisLock Exec ==> lockId:{}", (Object)lockId);
                if (lockId == null) {
                    throw new ConcurrentException();
                }
                result = invocation.proceed();
                this.redisUtils.unLock(keyValue, lockId);
            }
            catch (Throwable throwable) {
                this.redisUtils.unLock(keyValue, lockId);
                throw throwable;
            }
            return result;
        }
        return invocation.proceed();
    }

    public String getKeyValue(MethodInvocation invocation, Class<?> targetClass, String express) {
        String[] parameterNames = new DefaultParameterNameDiscoverer().getParameterNames(invocation.getMethod());
        String methodName = invocation.getMethod().getName();
        String className = "";
        if (targetClass != null) {
            className = targetClass.getName() + ":";
        }
        return REDIS_LOCK_KEY_PREFIX + className + methodName + ":" + ElParser.getKey(express, parameterNames, invocation.getArguments());
    }
}

