/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.commons;

import cn.acyou.leo.framework.constant.CommonErrorEnum;
import cn.acyou.leo.framework.context.AppContext;
import cn.acyou.leo.framework.exception.AssertException;
import cn.acyou.leo.framework.exception.ConcurrentException;
import cn.acyou.leo.framework.exception.DataPermissionDeniedException;
import cn.acyou.leo.framework.exception.DoConfirmException;
import cn.acyou.leo.framework.exception.DoRefreshException;
import cn.acyou.leo.framework.exception.IllegalRequestException;
import cn.acyou.leo.framework.exception.ModifiedByAnotherUserException;
import cn.acyou.leo.framework.exception.RemovedByAnotherUserException;
import cn.acyou.leo.framework.exception.RetryLaterException;
import cn.acyou.leo.framework.exception.ServerInternalException;
import cn.acyou.leo.framework.exception.ServiceException;
import cn.acyou.leo.framework.model.ErrorEnum;
import cn.acyou.leo.framework.model.Result;
import cn.acyou.leo.framework.prop.LeoProperty;
import com.google.common.base.Throwables;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.jdbc.BadSqlGrammarException;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;
import org.springframework.web.multipart.MaxUploadSizeExceededException;

@ControllerAdvice
@EnableConfigurationProperties(value={LeoProperty.class})
public class GlobalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);
    @Autowired
    private LeoProperty leoProperty;
    private static final String Page_Illegal = "PageSo$IllegalPageArgumentException";
    private static final Pattern MESSAGE_MATCHER = Pattern.compile("'([^']+)'");

    @ResponseBody
    @ExceptionHandler(value={BadSqlGrammarException.class})
    public Result<Object> handleBadSqlGrammarException(HttpServletRequest request, Exception e) {
        Result resultInfo = Result.error((ErrorEnum)CommonErrorEnum.BAD_SQL_ERROR);
        log.error(e.getMessage());
        AppContext.setExceptionResult(resultInfo);
        return resultInfo;
    }

    @ExceptionHandler(value={IllegalRequestException.class})
    public void handleIllegalRequestException(HttpServletResponse response, Exception ex) {
        response.setStatus(HttpStatus.FORBIDDEN.value());
        response.setCharacterEncoding("utf-8");
        response.setContentType("application/json; charset=utf-8");
        try (PrintWriter out = response.getWriter();){
            String responseJson = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{ex.getMessage()}) ? ex.getMessage() : "\u975e\u6cd5\u8bf7\u6c42";
            out.print(responseJson);
        }
        catch (IOException e) {
            log.error("response error\uff1a", (Throwable)e);
        }
    }

    @ExceptionHandler(value={ServerInternalException.class})
    public void handleServerInternalException(HttpServletResponse response, Exception ex) {
        response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
        response.setCharacterEncoding("utf-8");
        response.setContentType("application/json; charset=utf-8");
        try (PrintWriter out = response.getWriter();){
            String responseJson = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{ex.getMessage()}) ? ex.getMessage() : "\u5185\u90e8\u9519\u8bef";
            out.print(responseJson);
        }
        catch (IOException e) {
            log.error("response error\uff1a", (Throwable)e);
        }
    }

    @ResponseBody
    @ExceptionHandler(value={BindException.class})
    public Result<Object> handleBindException(BindException e) {
        return this.handlerParamNotValidException(e.getBindingResult());
    }

    @ResponseBody
    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public Result<Object> handleValidException(MethodArgumentNotValidException e) {
        return this.handlerParamNotValidException(e.getBindingResult());
    }

    @ResponseBody
    @ExceptionHandler(value={ConstraintViolationException.class})
    public Result<Object> handleConstraintViolationException(ConstraintViolationException e) {
        Result error = Result.error((ErrorEnum)CommonErrorEnum.E_PARAM_VALID_ERROR);
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        String firstMessage = null;
        for (ConstraintViolation constraintViolation : e.getConstraintViolations()) {
            map.put(constraintViolation.getPropertyPath().toString(), constraintViolation.getMessageTemplate());
            if (firstMessage != null) continue;
            firstMessage = constraintViolation.getMessageTemplate();
        }
        error.setMessage(firstMessage);
        error.setData(map);
        return error;
    }

    private Result<Object> handlerParamNotValidException(BindingResult bindingResult) {
        Result error = Result.error((ErrorEnum)CommonErrorEnum.E_PARAM_VALID_ERROR);
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        if (bindingResult.hasErrors()) {
            List allErrors = bindingResult.getAllErrors();
            for (ObjectError item : allErrors) {
                String message = "\u7c7b\u578b\u4e0d\u6b63\u786e";
                if (item instanceof FieldError) {
                    FieldError fieldItem = (FieldError)item;
                    String field = fieldItem.getField();
                    map.put(field, message);
                    continue;
                }
                String objectName = item.getObjectName();
                map.put("global", message);
            }
        }
        error.setData(map);
        return error;
    }

    @ExceptionHandler(value={ConcurrentException.class})
    @ResponseBody
    public Result<Object> handleConcurrentException(HttpServletRequest request, Exception e) {
        Result resultInfo = Result.error((ErrorEnum)CommonErrorEnum.CONCURRENT_ERROR);
        AppContext.setExceptionResult(resultInfo);
        return resultInfo;
    }

    @ExceptionHandler(value={MaxUploadSizeExceededException.class})
    @ResponseBody
    public Result<Object> handleMaxUploadSizeExceededException(HttpServletRequest request, Exception e) {
        Result resultInfo = Result.error((ErrorEnum)CommonErrorEnum.E_MAX_UPLOAD_SIZE_EXCEEDED);
        AppContext.setExceptionResult(resultInfo);
        return resultInfo;
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    @ResponseBody
    public Result<Object> handleHttpRequestMethodNotSupportedException(HttpServletRequest request, Exception e) {
        Result resultInfo = Result.error();
        resultInfo.setMessage(e.getMessage());
        AppContext.setExceptionResult(resultInfo);
        log.error("\u8bf7\u6c42\u63a5\u53e3 [{}] {}", (Object)request.getRequestURI(), (Object)e.getMessage());
        return resultInfo;
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    @ResponseBody
    public Result<Object> handleHttpMessageNotReadableException(HttpServletRequest request, Exception e) {
        Result resultInfo = Result.error((ErrorEnum)CommonErrorEnum.E_PARAM_CONVERT_ERROR);
        this.printErrorStackTraceInResultData(e, (Result<Object>)resultInfo);
        return resultInfo;
    }

    @ExceptionHandler(value={MethodArgumentTypeMismatchException.class})
    @ResponseBody
    public Result<Object> handleMethodArgumentTypeMismatchException(HttpServletRequest request, Exception e) {
        Result resultInfo = Result.error((ErrorEnum)CommonErrorEnum.E_PARAM_CONVERT_ERROR);
        this.printErrorStackTraceInResultData(e, (Result<Object>)resultInfo);
        return resultInfo;
    }

    @ExceptionHandler(value={AssertException.class})
    @ResponseBody
    public Result<Object> handleAssertException(HttpServletRequest request, Exception e) {
        Result resultInfo = Result.error();
        resultInfo.setMessage(e.getMessage());
        AppContext.setExceptionResult(resultInfo);
        return resultInfo;
    }

    @ExceptionHandler(value={DuplicateKeyException.class})
    @ResponseBody
    public Result<Object> handleDuplicateKeyException(HttpServletRequest request, Exception e) {
        Matcher m;
        Result resultInfo = Result.error();
        Throwable rootCause = Throwables.getRootCause((Throwable)e);
        String rootMessage = rootCause.getMessage();
        if (rootMessage.matches("Duplicate entry(.*)") && (m = MESSAGE_MATCHER.matcher(rootMessage)).find()) {
            resultInfo.setMessage(m.group() + "\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u66f4\u6362\u91cd\u8bd5\uff01");
        }
        this.printErrorStackTraceInResultData(e, (Result<Object>)resultInfo);
        return resultInfo;
    }

    @ExceptionHandler(value={DataIntegrityViolationException.class})
    @ResponseBody
    public Result<Object> handleDataIntegrityViolationException(HttpServletRequest request, Exception e) {
        Result resultInfo = Result.error();
        resultInfo.setMessage("\u8fdd\u53cd\u6570\u636e\u5b8c\u6574\u6027\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\uff01");
        log.error(e.getMessage(), (Throwable)e);
        this.printErrorStackTraceInResultData(e, (Result<Object>)resultInfo);
        return resultInfo;
    }

    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    @ResponseBody
    public Result<Object> handleMissingServletRequestParameterException(HttpServletRequest request, Exception e) {
        Result resultInfo = Result.error();
        String message = e.getMessage();
        int start = message.indexOf("parameter '") + 11;
        int end = message.indexOf("'", start);
        String realMsg = message.substring(start, end) + " \u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01";
        resultInfo.setMessage(realMsg);
        log.error(realMsg);
        this.printErrorStackTraceInResultData(e, (Result<Object>)resultInfo);
        return resultInfo;
    }

    @ExceptionHandler(value={DoConfirmException.class})
    @ResponseBody
    public Result<Object> handleNeedSureException(HttpServletRequest request, Exception e) {
        Result resultInfo = Result.error((ErrorEnum)CommonErrorEnum.E_NEED_SURE);
        resultInfo.setMessage(e.getMessage());
        AppContext.setExceptionResult(resultInfo);
        return resultInfo;
    }

    @ExceptionHandler(value={DoRefreshException.class})
    @ResponseBody
    public Result<Object> handleDoRefreshException(HttpServletRequest request, Exception e) {
        Result resultInfo = Result.error((ErrorEnum)CommonErrorEnum.E_DO_REFRESH);
        resultInfo.setMessage(e.getMessage());
        AppContext.setExceptionResult(resultInfo);
        return resultInfo;
    }

    @ExceptionHandler(value={ServiceException.class, RetryLaterException.class})
    @ResponseBody
    public Result<Object> handleServiceException(HttpServletRequest request, Exception e) {
        Result resultInfo = Result.error();
        if (e instanceof ServiceException) {
            ServiceException serviceException = (ServiceException)e;
            if (serviceException.getResult() != null) {
                return serviceException.getResult();
            }
            if (StringUtils.isNotBlank((CharSequence)e.getMessage())) {
                resultInfo.setMessage(e.getMessage());
            }
            this.printErrorStackTraceInResultData(e, (Result<Object>)resultInfo);
        }
        return resultInfo;
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    public Result<Object> handleException(HttpServletRequest request, Exception e) {
        Result resultInfo = Result.error();
        log.error("\u7edf\u4e00\u672a\u77e5\u5f02\u5e38\u5904\u7406 => \u8bf7\u6c42\u8def\u5f84\uff1a" + request.getRequestURI() + "\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a" + e.getMessage());
        log.error(e.getMessage(), (Throwable)e);
        Throwable rootCause = Throwables.getRootCause((Throwable)e);
        if (rootCause instanceof ModifiedByAnotherUserException) {
            resultInfo = Result.error((ErrorEnum)CommonErrorEnum.E_OPTMISTIC_MODIFIED);
        }
        if (rootCause instanceof RemovedByAnotherUserException) {
            resultInfo = Result.error((ErrorEnum)CommonErrorEnum.E_OPTMISTIC_REMOVE);
        }
        if (rootCause instanceof DataPermissionDeniedException) {
            resultInfo = Result.error((ErrorEnum)CommonErrorEnum.E_DATA_PERMISSION_DENIED);
            String message = rootCause.getMessage();
            if (StringUtils.isNotBlank((CharSequence)message)) {
                resultInfo.setMessage(message);
            }
        }
        this.printErrorStackTraceInResultData(e, (Result<Object>)resultInfo);
        return resultInfo;
    }

    private void printErrorStackTraceInResultData(Exception e, Result<Object> resultInfo) {
        try {
            if (resultInfo.getData() == null) {
                ByteArrayOutputStream buf = new ByteArrayOutputStream();
                e.printStackTrace(new PrintWriter(buf, true));
                buf.close();
                resultInfo.setData((Object)buf.toString());
                AppContext.setExceptionResult(resultInfo);
                if (!this.leoProperty.isPrintToResult()) {
                    resultInfo.setData(null);
                }
            }
        }
        catch (IOException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
    }
}

