/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.commons;

import cn.acyou.leo.framework.constant.CommonErrorEnum;
import cn.acyou.leo.framework.exception.ServiceException;
import cn.acyou.leo.framework.model.PageData;
import cn.acyou.leo.framework.model.PageSo;
import cn.acyou.leo.framework.util.BeanCopyUtil;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.data.domain.Page;
import org.springframework.util.StringUtils;

public class PageQuery {
    public static <T> PageData<T> convert(Page<T> springPage) {
        Integer pageNum = springPage.getNumber() != 0 ? springPage.getNumber() : 1;
        PageData resultData = new PageData(pageNum, Integer.valueOf(springPage.getSize()));
        resultData.setTotal(Long.valueOf(springPage.getTotalElements()));
        resultData.setList(springPage.getContent());
        return resultData;
    }

    public static <T> PageData<T> convert(PageInfo<T> pageInfo) {
        Integer pageNum = pageInfo.getPageNum() != 0 ? pageInfo.getPageNum() : 1;
        PageData resultData = new PageData(pageNum, Integer.valueOf(pageInfo.getPageSize()));
        resultData.setTotal(Long.valueOf(pageInfo.getTotal()));
        resultData.setList(pageInfo.getList());
        return resultData;
    }

    public static <E, T> PageData<T> convert(PageInfo<E> pageInfo, Class<T> tarClass) {
        Integer pageNum = pageInfo.getPageNum() != 0 ? pageInfo.getPageNum() : 1;
        PageData resultData = new PageData(pageNum, Integer.valueOf(pageInfo.getPageSize()));
        resultData.setTotal(Long.valueOf(pageInfo.getTotal()));
        resultData.setList(BeanCopyUtil.copyList(pageInfo.getList(), tarClass));
        return resultData;
    }

    public static <T> PageData<T> convert(List<T> dataList) {
        PageInfo pageInfo = new PageInfo(dataList);
        return PageQuery.convert(pageInfo);
    }

    public static PageQuery startPage(Integer pageNum, Integer pageSize) {
        PageQuery.judgeNotNull(pageNum, pageSize);
        PageHelper.startPage((int)pageNum, (int)pageSize);
        return new PageQuery();
    }

    public static PageQuery startPage(Integer pageNum, Integer pageSize, Boolean pageSizeZero) {
        PageQuery.judgeNotNull(pageNum, pageSize);
        PageHelper.startPage((int)pageNum, (int)pageSize, (boolean)true, null, (Boolean)pageSizeZero);
        return new PageQuery();
    }

    public static PageQuery startPage(Integer pageNum, Integer pageSize, String orderBy) {
        PageQuery.judgeNotNull(pageNum, pageSize);
        PageHelper.startPage((int)pageNum, (int)pageSize, (String)orderBy);
        return new PageQuery();
    }

    public static PageQuery startPage(PageSo pageSo) {
        return PageQuery.startPage(pageSo.getPageNum(), pageSo.getPageSize(), PageQuery.convertOrderBy(pageSo));
    }

    public static PageQuery startPage(PageSo pageSo, Boolean pageSizeZero) {
        PageQuery.judgeNotNull(pageSo.getPageNum(), pageSo.getPageSize());
        PageHelper.startPage((int)pageSo.getPageNum(), (int)pageSo.getPageSize(), (boolean)true, null, (Boolean)pageSizeZero);
        PageHelper.orderBy((String)PageQuery.convertOrderBy(pageSo));
        return new PageQuery();
    }

    public <T> PageData<T> selectMapper(List<T> queryList) {
        PageInfo pageInfo = new PageInfo(queryList);
        return PageQuery.convert(pageInfo);
    }

    public <E, T> PageData<T> selectMapper(List<E> queryList, Class<T> tarClass) {
        PageInfo pageInfo = new PageInfo(queryList);
        return PageQuery.convert(pageInfo, tarClass);
    }

    public static <T> PageData<T> empty() {
        PageData pageData = new PageData(Integer.valueOf(1), Integer.valueOf(10));
        pageData.setTotal(Long.valueOf(0L));
        return pageData;
    }

    public static <T> PageData<T> empty(int pageSize) {
        PageData pageData = new PageData(Integer.valueOf(1), Integer.valueOf(pageSize));
        pageData.setTotal(Long.valueOf(0L));
        return pageData;
    }

    private static void judgeNotNull(Integer pageNum, Integer pageSize) {
        if (pageNum == null) {
            throw new ServiceException("[pageNum]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (pageSize == null) {
            throw new ServiceException("[pageSize]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    public static String convertOrderBy(PageSo pageSo) {
        ArrayList<String> orderBySqlList = new ArrayList<String>();
        Map supportFieldMap = pageSo.supportField();
        String sortsStr = pageSo.getSorts();
        boolean illegalOrderBy = false;
        if (StringUtils.hasText((String)sortsStr) && supportFieldMap != null && !supportFieldMap.isEmpty()) {
            String[] orderItems;
            Set supportKeys = supportFieldMap.keySet();
            for (String orderItem : orderItems = sortsStr.split(",")) {
                String[] split = orderItem.split("-");
                if (split.length % 2 == 0) {
                    String key = split[0];
                    String type = split[1];
                    if (StringUtils.hasText((String)key) && StringUtils.hasText((String)type) && supportKeys.contains(key) && PageQuery.isOrderByType(type)) {
                        orderBySqlList.add((String)supportFieldMap.get(key) + " " + type.toLowerCase());
                        continue;
                    }
                    illegalOrderBy = true;
                    continue;
                }
                illegalOrderBy = true;
            }
        }
        if (illegalOrderBy) {
            throw new ServiceException(CommonErrorEnum.E_INVALID_SORT_PARAMETER);
        }
        if (!orderBySqlList.isEmpty()) {
            return StringUtils.collectionToDelimitedString(orderBySqlList, (String)", ");
        }
        return null;
    }

    private static boolean isOrderByType(String type) {
        return OrderBySymbols.asc.name().equalsIgnoreCase(type) || OrderBySymbols.desc.name().equalsIgnoreCase(type);
    }

    private static enum OrderBySymbols {
        asc,
        desc;

    }
}

