/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.constraintvalidators;

import cn.acyou.leo.framework.annotation.valid.DictValue;
import cn.acyou.leo.framework.service.DictValidService;
import cn.acyou.leo.framework.util.SpringHelper;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DictValueConstraintValidator
implements ConstraintValidator<DictValue, Object> {
    private static final Logger log = LoggerFactory.getLogger(DictValueConstraintValidator.class);
    private String dictCode;

    public void initialize(DictValue constraintAnnotation) {
        this.dictCode = constraintAnnotation.dictCode();
    }

    public boolean isValid(Object value, ConstraintValidatorContext context) {
        if (this.dictCode != null && this.dictCode.length() > 0) {
            DictValidService dictValidService = SpringHelper.getBean(DictValidService.class);
            return dictValidService.validDictValue(this.dictCode, value.toString());
        }
        return true;
    }
}

