/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.constraintvalidators;

import cn.acyou.leo.framework.annotation.valid.ListValue;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public class ListValueConstraintValidator
implements ConstraintValidator<ListValue, Object> {
    private Set<Integer> rangeValues = new HashSet<Integer>();
    private Set<String> strRangeValues = new HashSet<String>();

    public void initialize(ListValue constraintAnnotation) {
        int[] values = constraintAnnotation.values();
        String[] strValues = constraintAnnotation.strValues();
        for (int val : values) {
            this.rangeValues.add(val);
        }
        this.strRangeValues.addAll(Arrays.asList(strValues));
    }

    public boolean isValid(Object value, ConstraintValidatorContext context) {
        if (value != null) {
            if (value instanceof String) {
                return this.strRangeValues.contains(value);
            }
            return this.rangeValues.contains(value);
        }
        return true;
    }
}

