/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.context;

import cn.acyou.leo.framework.annotation.authz.RequiresPermissions;
import cn.acyou.leo.framework.annotation.authz.RequiresRoles;
import cn.acyou.leo.framework.base.ClientLanguage;
import cn.acyou.leo.framework.base.ClientType;
import cn.acyou.leo.framework.base.LoginUser;
import cn.acyou.leo.framework.constant.CommonErrorEnum;
import cn.acyou.leo.framework.exception.ServiceException;
import cn.acyou.leo.framework.model.Result;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class AppContext {
    private static final ThreadLocal<String> IP_TL = new ThreadLocal();
    private static final ThreadLocal<String> TOKEN_TL = new ThreadLocal();
    private static final ThreadLocal<LoginUser> LOGIN_USER_TL = new ThreadLocal();
    private static final ThreadLocal<ClientType> CLIENT_TYPE_TL = new ThreadLocal();
    private static final ThreadLocal<ClientLanguage> CLIENT_LANGUAGE_TL = new ThreadLocal();
    private static final ThreadLocal<String> ACTION_URL_TL = new ThreadLocal();
    private static final ThreadLocal<String[]> ACTION_API_OPERATION_TL = new ThreadLocal();
    private static final ThreadLocal<Long> REQUEST_TIMESTAMP_TL = new ThreadLocal();
    private static final ThreadLocal<Result<?>> EXCEPTION_RESULT_TL = new ThreadLocal();
    private static final ThreadLocal<String> REQUEST_BODY_TL = new ThreadLocal();
    private static final List<ThreadLocal<?>> THREAD_LOCAL_LIST = new ArrayList();

    public static String getIp() {
        return IP_TL.get();
    }

    public static void setIp(String ip) {
        IP_TL.set(ip);
    }

    public static void clearIp() {
        IP_TL.remove();
    }

    public static String getToken() {
        return TOKEN_TL.get();
    }

    public static void setToken(String token) {
        TOKEN_TL.set(token);
    }

    public static void clearToken() {
        TOKEN_TL.remove();
    }

    public static Long getUserId() {
        LoginUser loginUser = AppContext.getLoginUser();
        if (loginUser == null) {
            return null;
        }
        return loginUser.getUserId();
    }

    public static Long checkGetUserId() {
        LoginUser loginUser = AppContext.getLoginUser();
        if (loginUser == null) {
            throw new ServiceException(CommonErrorEnum.E_UNAUTHENTICATED);
        }
        return loginUser.getUserId();
    }

    public static LoginUser getLoginUser() {
        return LOGIN_USER_TL.get();
    }

    public static void setLoginUser(LoginUser user) {
        LOGIN_USER_TL.set(user);
    }

    public static void clearLoginUser() {
        LOGIN_USER_TL.remove();
    }

    public static String getActionUrl() {
        return ACTION_URL_TL.get();
    }

    public static void setActionUrl(String action) {
        ACTION_URL_TL.set(action);
    }

    public static void setActionApiOperation(String[] actionApiOperation) {
        ACTION_API_OPERATION_TL.set(actionApiOperation);
    }

    public static String[] getActionApiMethodInfo() {
        return ACTION_API_OPERATION_TL.get();
    }

    public static String getActionApiMethodInfoRemark() {
        String[] values = ACTION_API_OPERATION_TL.get();
        if (values != null && values.length > 0) {
            return values[0];
        }
        return "";
    }

    public static void clearActionApiMethodInfo() {
        ACTION_API_OPERATION_TL.remove();
    }

    public static String getActionApiOperationValue() {
        String[] values = ACTION_API_OPERATION_TL.get();
        if (values != null && values.length > 1) {
            return values[1];
        }
        return "";
    }

    public static boolean getActionDebug() {
        String[] values = ACTION_API_OPERATION_TL.get();
        if (values != null && values.length > 2) {
            return Boolean.parseBoolean(values[2]);
        }
        return Boolean.TRUE;
    }

    public static void clearAction() {
        ACTION_URL_TL.remove();
    }

    public static ClientType getClientType() {
        return CLIENT_TYPE_TL.get();
    }

    public static void setClientType(ClientType clientType) {
        CLIENT_TYPE_TL.set(clientType);
    }

    public static void clearClientType() {
        CLIENT_TYPE_TL.remove();
    }

    public static Long getRequestTimeStamp() {
        return REQUEST_TIMESTAMP_TL.get();
    }

    public static void setRequestTimeStamp(Long timeStamp) {
        REQUEST_TIMESTAMP_TL.set(timeStamp);
    }

    public static void clearRequestTimeStamp() {
        REQUEST_TIMESTAMP_TL.remove();
    }

    public static Result<?> getExceptionResult() {
        return EXCEPTION_RESULT_TL.get();
    }

    public static void setExceptionResult(Result<?> exceptionResult) {
        EXCEPTION_RESULT_TL.set(exceptionResult);
    }

    public static void clearExceptionResult() {
        EXCEPTION_RESULT_TL.remove();
    }

    public static String getRequestBody() {
        return REQUEST_BODY_TL.get();
    }

    public static void setRequestBody(String requestBodyStr) {
        REQUEST_BODY_TL.set(requestBodyStr);
    }

    public static void clearRequestParams() {
        REQUEST_BODY_TL.remove();
    }

    public static ClientLanguage getClientLanguage() {
        return CLIENT_LANGUAGE_TL.get();
    }

    public static void setClientLanguage(ClientLanguage clientLanguage) {
        CLIENT_LANGUAGE_TL.set(clientLanguage);
    }

    public static void clearThreadLocal() {
        for (ThreadLocal<?> tl : THREAD_LOCAL_LIST) {
            if (tl == null) continue;
            tl.remove();
        }
    }

    public static AppContextBean convertAppContextBean() {
        return AppContextBean.builder().ip(AppContext.getIp()).loginUser(AppContext.getLoginUser()).clientType(AppContext.getClientType()).clientLanguage(AppContext.getClientLanguage()).actionUrl(AppContext.getActionUrl()).actionApiOperation(ACTION_API_OPERATION_TL.get()).requestTimestamp(AppContext.getRequestTimeStamp()).exceptionResult(AppContext.getExceptionResult()).requestBodyStr(AppContext.getRequestBody()).build();
    }

    static {
        THREAD_LOCAL_LIST.add(IP_TL);
        THREAD_LOCAL_LIST.add(TOKEN_TL);
        THREAD_LOCAL_LIST.add(LOGIN_USER_TL);
        THREAD_LOCAL_LIST.add(CLIENT_TYPE_TL);
        THREAD_LOCAL_LIST.add(CLIENT_LANGUAGE_TL);
        THREAD_LOCAL_LIST.add(ACTION_URL_TL);
        THREAD_LOCAL_LIST.add(ACTION_API_OPERATION_TL);
        THREAD_LOCAL_LIST.add(REQUEST_TIMESTAMP_TL);
        THREAD_LOCAL_LIST.add(EXCEPTION_RESULT_TL);
        THREAD_LOCAL_LIST.add(REQUEST_BODY_TL);
    }

    public static class MethodInfoBean {
        private String methodInfo = "";
        private String apiRemark = "";
        private String debug = "false";
        private boolean printRequestBody = true;
        private boolean printResponseBody = false;
        private ApiOperation apiOperation;
        private RequiresRoles requiresRoles;
        private RequiresPermissions requiresPermissions;

        public static MethodInfoBeanBuilder builder() {
            return new MethodInfoBeanBuilder();
        }

        public String getMethodInfo() {
            return this.methodInfo;
        }

        public String getApiRemark() {
            return this.apiRemark;
        }

        public String getDebug() {
            return this.debug;
        }

        public boolean isPrintRequestBody() {
            return this.printRequestBody;
        }

        public boolean isPrintResponseBody() {
            return this.printResponseBody;
        }

        public ApiOperation getApiOperation() {
            return this.apiOperation;
        }

        public RequiresRoles getRequiresRoles() {
            return this.requiresRoles;
        }

        public RequiresPermissions getRequiresPermissions() {
            return this.requiresPermissions;
        }

        public void setMethodInfo(String methodInfo) {
            this.methodInfo = methodInfo;
        }

        public void setApiRemark(String apiRemark) {
            this.apiRemark = apiRemark;
        }

        public void setDebug(String debug) {
            this.debug = debug;
        }

        public void setPrintRequestBody(boolean printRequestBody) {
            this.printRequestBody = printRequestBody;
        }

        public void setPrintResponseBody(boolean printResponseBody) {
            this.printResponseBody = printResponseBody;
        }

        public void setApiOperation(ApiOperation apiOperation) {
            this.apiOperation = apiOperation;
        }

        public void setRequiresRoles(RequiresRoles requiresRoles) {
            this.requiresRoles = requiresRoles;
        }

        public void setRequiresPermissions(RequiresPermissions requiresPermissions) {
            this.requiresPermissions = requiresPermissions;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MethodInfoBean)) {
                return false;
            }
            MethodInfoBean other = (MethodInfoBean)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isPrintRequestBody() != other.isPrintRequestBody()) {
                return false;
            }
            if (this.isPrintResponseBody() != other.isPrintResponseBody()) {
                return false;
            }
            String this$methodInfo = this.getMethodInfo();
            String other$methodInfo = other.getMethodInfo();
            if (this$methodInfo == null ? other$methodInfo != null : !this$methodInfo.equals(other$methodInfo)) {
                return false;
            }
            String this$apiRemark = this.getApiRemark();
            String other$apiRemark = other.getApiRemark();
            if (this$apiRemark == null ? other$apiRemark != null : !this$apiRemark.equals(other$apiRemark)) {
                return false;
            }
            String this$debug = this.getDebug();
            String other$debug = other.getDebug();
            if (this$debug == null ? other$debug != null : !this$debug.equals(other$debug)) {
                return false;
            }
            ApiOperation this$apiOperation = this.getApiOperation();
            ApiOperation other$apiOperation = other.getApiOperation();
            if (this$apiOperation == null ? other$apiOperation != null : !this$apiOperation.equals(other$apiOperation)) {
                return false;
            }
            RequiresRoles this$requiresRoles = this.getRequiresRoles();
            RequiresRoles other$requiresRoles = other.getRequiresRoles();
            if (this$requiresRoles == null ? other$requiresRoles != null : !this$requiresRoles.equals(other$requiresRoles)) {
                return false;
            }
            RequiresPermissions this$requiresPermissions = this.getRequiresPermissions();
            RequiresPermissions other$requiresPermissions = other.getRequiresPermissions();
            return !(this$requiresPermissions == null ? other$requiresPermissions != null : !this$requiresPermissions.equals(other$requiresPermissions));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MethodInfoBean;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isPrintRequestBody() ? 79 : 97);
            result = result * 59 + (this.isPrintResponseBody() ? 79 : 97);
            String $methodInfo = this.getMethodInfo();
            result = result * 59 + ($methodInfo == null ? 43 : $methodInfo.hashCode());
            String $apiRemark = this.getApiRemark();
            result = result * 59 + ($apiRemark == null ? 43 : $apiRemark.hashCode());
            String $debug = this.getDebug();
            result = result * 59 + ($debug == null ? 43 : $debug.hashCode());
            ApiOperation $apiOperation = this.getApiOperation();
            result = result * 59 + ($apiOperation == null ? 43 : $apiOperation.hashCode());
            RequiresRoles $requiresRoles = this.getRequiresRoles();
            result = result * 59 + ($requiresRoles == null ? 43 : $requiresRoles.hashCode());
            RequiresPermissions $requiresPermissions = this.getRequiresPermissions();
            result = result * 59 + ($requiresPermissions == null ? 43 : $requiresPermissions.hashCode());
            return result;
        }

        public String toString() {
            return "AppContext.MethodInfoBean(methodInfo=" + this.getMethodInfo() + ", apiRemark=" + this.getApiRemark() + ", debug=" + this.getDebug() + ", printRequestBody=" + this.isPrintRequestBody() + ", printResponseBody=" + this.isPrintResponseBody() + ", apiOperation=" + this.getApiOperation() + ", requiresRoles=" + this.getRequiresRoles() + ", requiresPermissions=" + this.getRequiresPermissions() + ")";
        }

        public MethodInfoBean(String methodInfo, String apiRemark, String debug, boolean printRequestBody, boolean printResponseBody, ApiOperation apiOperation, RequiresRoles requiresRoles, RequiresPermissions requiresPermissions) {
            this.methodInfo = methodInfo;
            this.apiRemark = apiRemark;
            this.debug = debug;
            this.printRequestBody = printRequestBody;
            this.printResponseBody = printResponseBody;
            this.apiOperation = apiOperation;
            this.requiresRoles = requiresRoles;
            this.requiresPermissions = requiresPermissions;
        }

        public MethodInfoBean() {
        }

        public static class MethodInfoBeanBuilder {
            private String methodInfo;
            private String apiRemark;
            private String debug;
            private boolean printRequestBody;
            private boolean printResponseBody;
            private ApiOperation apiOperation;
            private RequiresRoles requiresRoles;
            private RequiresPermissions requiresPermissions;

            MethodInfoBeanBuilder() {
            }

            public MethodInfoBeanBuilder methodInfo(String methodInfo) {
                this.methodInfo = methodInfo;
                return this;
            }

            public MethodInfoBeanBuilder apiRemark(String apiRemark) {
                this.apiRemark = apiRemark;
                return this;
            }

            public MethodInfoBeanBuilder debug(String debug) {
                this.debug = debug;
                return this;
            }

            public MethodInfoBeanBuilder printRequestBody(boolean printRequestBody) {
                this.printRequestBody = printRequestBody;
                return this;
            }

            public MethodInfoBeanBuilder printResponseBody(boolean printResponseBody) {
                this.printResponseBody = printResponseBody;
                return this;
            }

            public MethodInfoBeanBuilder apiOperation(ApiOperation apiOperation) {
                this.apiOperation = apiOperation;
                return this;
            }

            public MethodInfoBeanBuilder requiresRoles(RequiresRoles requiresRoles) {
                this.requiresRoles = requiresRoles;
                return this;
            }

            public MethodInfoBeanBuilder requiresPermissions(RequiresPermissions requiresPermissions) {
                this.requiresPermissions = requiresPermissions;
                return this;
            }

            public MethodInfoBean build() {
                return new MethodInfoBean(this.methodInfo, this.apiRemark, this.debug, this.printRequestBody, this.printResponseBody, this.apiOperation, this.requiresRoles, this.requiresPermissions);
            }

            public String toString() {
                return "AppContext.MethodInfoBean.MethodInfoBeanBuilder(methodInfo=" + this.methodInfo + ", apiRemark=" + this.apiRemark + ", debug=" + this.debug + ", printRequestBody=" + this.printRequestBody + ", printResponseBody=" + this.printResponseBody + ", apiOperation=" + this.apiOperation + ", requiresRoles=" + this.requiresRoles + ", requiresPermissions=" + this.requiresPermissions + ")";
            }
        }
    }

    public static class AppContextBean {
        private String ip;
        private LoginUser loginUser;
        private ClientType clientType;
        private ClientLanguage clientLanguage;
        private String actionUrl;
        private String[] actionApiOperation;
        private Long requestTimestamp;
        private Result<?> exceptionResult;
        private String requestBodyStr;

        AppContextBean(String ip, LoginUser loginUser, ClientType clientType, ClientLanguage clientLanguage, String actionUrl, String[] actionApiOperation, Long requestTimestamp, Result<?> exceptionResult, String requestBodyStr) {
            this.ip = ip;
            this.loginUser = loginUser;
            this.clientType = clientType;
            this.clientLanguage = clientLanguage;
            this.actionUrl = actionUrl;
            this.actionApiOperation = actionApiOperation;
            this.requestTimestamp = requestTimestamp;
            this.exceptionResult = exceptionResult;
            this.requestBodyStr = requestBodyStr;
        }

        public static AppContextBeanBuilder builder() {
            return new AppContextBeanBuilder();
        }

        public String getIp() {
            return this.ip;
        }

        public LoginUser getLoginUser() {
            return this.loginUser;
        }

        public ClientType getClientType() {
            return this.clientType;
        }

        public ClientLanguage getClientLanguage() {
            return this.clientLanguage;
        }

        public String getActionUrl() {
            return this.actionUrl;
        }

        public String[] getActionApiOperation() {
            return this.actionApiOperation;
        }

        public Long getRequestTimestamp() {
            return this.requestTimestamp;
        }

        public Result<?> getExceptionResult() {
            return this.exceptionResult;
        }

        public String getRequestBodyStr() {
            return this.requestBodyStr;
        }

        public void setIp(String ip) {
            this.ip = ip;
        }

        public void setLoginUser(LoginUser loginUser) {
            this.loginUser = loginUser;
        }

        public void setClientType(ClientType clientType) {
            this.clientType = clientType;
        }

        public void setClientLanguage(ClientLanguage clientLanguage) {
            this.clientLanguage = clientLanguage;
        }

        public void setActionUrl(String actionUrl) {
            this.actionUrl = actionUrl;
        }

        public void setActionApiOperation(String[] actionApiOperation) {
            this.actionApiOperation = actionApiOperation;
        }

        public void setRequestTimestamp(Long requestTimestamp) {
            this.requestTimestamp = requestTimestamp;
        }

        public void setExceptionResult(Result<?> exceptionResult) {
            this.exceptionResult = exceptionResult;
        }

        public void setRequestBodyStr(String requestBodyStr) {
            this.requestBodyStr = requestBodyStr;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AppContextBean)) {
                return false;
            }
            AppContextBean other = (AppContextBean)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$requestTimestamp = this.getRequestTimestamp();
            Long other$requestTimestamp = other.getRequestTimestamp();
            if (this$requestTimestamp == null ? other$requestTimestamp != null : !((Object)this$requestTimestamp).equals(other$requestTimestamp)) {
                return false;
            }
            String this$ip = this.getIp();
            String other$ip = other.getIp();
            if (this$ip == null ? other$ip != null : !this$ip.equals(other$ip)) {
                return false;
            }
            LoginUser this$loginUser = this.getLoginUser();
            LoginUser other$loginUser = other.getLoginUser();
            if (this$loginUser == null ? other$loginUser != null : !((Object)this$loginUser).equals(other$loginUser)) {
                return false;
            }
            ClientType this$clientType = this.getClientType();
            ClientType other$clientType = other.getClientType();
            if (this$clientType == null ? other$clientType != null : !((Object)((Object)this$clientType)).equals((Object)other$clientType)) {
                return false;
            }
            ClientLanguage this$clientLanguage = this.getClientLanguage();
            ClientLanguage other$clientLanguage = other.getClientLanguage();
            if (this$clientLanguage == null ? other$clientLanguage != null : !((Object)((Object)this$clientLanguage)).equals((Object)other$clientLanguage)) {
                return false;
            }
            String this$actionUrl = this.getActionUrl();
            String other$actionUrl = other.getActionUrl();
            if (this$actionUrl == null ? other$actionUrl != null : !this$actionUrl.equals(other$actionUrl)) {
                return false;
            }
            if (!Arrays.deepEquals(this.getActionApiOperation(), other.getActionApiOperation())) {
                return false;
            }
            Result<?> this$exceptionResult = this.getExceptionResult();
            Result<?> other$exceptionResult = other.getExceptionResult();
            if (this$exceptionResult == null ? other$exceptionResult != null : !this$exceptionResult.equals(other$exceptionResult)) {
                return false;
            }
            String this$requestBodyStr = this.getRequestBodyStr();
            String other$requestBodyStr = other.getRequestBodyStr();
            return !(this$requestBodyStr == null ? other$requestBodyStr != null : !this$requestBodyStr.equals(other$requestBodyStr));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AppContextBean;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $requestTimestamp = this.getRequestTimestamp();
            result = result * 59 + ($requestTimestamp == null ? 43 : ((Object)$requestTimestamp).hashCode());
            String $ip = this.getIp();
            result = result * 59 + ($ip == null ? 43 : $ip.hashCode());
            LoginUser $loginUser = this.getLoginUser();
            result = result * 59 + ($loginUser == null ? 43 : ((Object)$loginUser).hashCode());
            ClientType $clientType = this.getClientType();
            result = result * 59 + ($clientType == null ? 43 : ((Object)((Object)$clientType)).hashCode());
            ClientLanguage $clientLanguage = this.getClientLanguage();
            result = result * 59 + ($clientLanguage == null ? 43 : ((Object)((Object)$clientLanguage)).hashCode());
            String $actionUrl = this.getActionUrl();
            result = result * 59 + ($actionUrl == null ? 43 : $actionUrl.hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getActionApiOperation());
            Result<?> $exceptionResult = this.getExceptionResult();
            result = result * 59 + ($exceptionResult == null ? 43 : $exceptionResult.hashCode());
            String $requestBodyStr = this.getRequestBodyStr();
            result = result * 59 + ($requestBodyStr == null ? 43 : $requestBodyStr.hashCode());
            return result;
        }

        public String toString() {
            return "AppContext.AppContextBean(ip=" + this.getIp() + ", loginUser=" + this.getLoginUser() + ", clientType=" + (Object)((Object)this.getClientType()) + ", clientLanguage=" + (Object)((Object)this.getClientLanguage()) + ", actionUrl=" + this.getActionUrl() + ", actionApiOperation=" + Arrays.deepToString(this.getActionApiOperation()) + ", requestTimestamp=" + this.getRequestTimestamp() + ", exceptionResult=" + this.getExceptionResult() + ", requestBodyStr=" + this.getRequestBodyStr() + ")";
        }

        public static class AppContextBeanBuilder {
            private String ip;
            private LoginUser loginUser;
            private ClientType clientType;
            private ClientLanguage clientLanguage;
            private String actionUrl;
            private String[] actionApiOperation;
            private Long requestTimestamp;
            private Result<?> exceptionResult;
            private String requestBodyStr;

            AppContextBeanBuilder() {
            }

            public AppContextBeanBuilder ip(String ip) {
                this.ip = ip;
                return this;
            }

            public AppContextBeanBuilder loginUser(LoginUser loginUser) {
                this.loginUser = loginUser;
                return this;
            }

            public AppContextBeanBuilder clientType(ClientType clientType) {
                this.clientType = clientType;
                return this;
            }

            public AppContextBeanBuilder clientLanguage(ClientLanguage clientLanguage) {
                this.clientLanguage = clientLanguage;
                return this;
            }

            public AppContextBeanBuilder actionUrl(String actionUrl) {
                this.actionUrl = actionUrl;
                return this;
            }

            public AppContextBeanBuilder actionApiOperation(String[] actionApiOperation) {
                this.actionApiOperation = actionApiOperation;
                return this;
            }

            public AppContextBeanBuilder requestTimestamp(Long requestTimestamp) {
                this.requestTimestamp = requestTimestamp;
                return this;
            }

            public AppContextBeanBuilder exceptionResult(Result<?> exceptionResult) {
                this.exceptionResult = exceptionResult;
                return this;
            }

            public AppContextBeanBuilder requestBodyStr(String requestBodyStr) {
                this.requestBodyStr = requestBodyStr;
                return this;
            }

            public AppContextBean build() {
                return new AppContextBean(this.ip, this.loginUser, this.clientType, this.clientLanguage, this.actionUrl, this.actionApiOperation, this.requestTimestamp, this.exceptionResult, this.requestBodyStr);
            }

            public String toString() {
                return "AppContext.AppContextBean.AppContextBeanBuilder(ip=" + this.ip + ", loginUser=" + this.loginUser + ", clientType=" + (Object)((Object)this.clientType) + ", clientLanguage=" + (Object)((Object)this.clientLanguage) + ", actionUrl=" + this.actionUrl + ", actionApiOperation=" + Arrays.deepToString(this.actionApiOperation) + ", requestTimestamp=" + this.requestTimestamp + ", exceptionResult=" + this.exceptionResult + ", requestBodyStr=" + this.requestBodyStr + ")";
            }
        }
    }
}

