/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.downloader;

import cn.acyou.leo.framework.downloader.ext.ByteArrayResponseExtractor;
import cn.acyou.leo.framework.downloader.support.DownloadProgressPrinter;
import cn.acyou.leo.framework.downloader.utils.RestTemplateBuilder;
import cn.acyou.leo.framework.util.UrlUtil;
import cn.acyou.leo.framework.util.WorkUtil;
import cn.acyou.leo.framework.util.function.Task;
import cn.hutool.core.math.Calculator;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.apache.tomcat.util.http.fileupload.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RequestCallback;
import org.springframework.web.client.ResponseExtractor;
import org.springframework.web.client.RestTemplate;

public class DownloadUtil {
    private static final Logger log = LoggerFactory.getLogger(DownloadUtil.class);
    private static final RestTemplate restTemplate = RestTemplateBuilder.builder().build();
    private static final DownloadProgressPrinter downloadProgressPrinter = DownloadProgressPrinter.defaultDownloadProgressPrinter();
    private static Proxy proxy;

    private DownloadUtil() {
    }

    public static void setProxy(Proxy proxy) {
        DownloadUtil.proxy = proxy;
        SimpleClientHttpRequestFactory requestFactory = new SimpleClientHttpRequestFactory();
        requestFactory.setProxy(proxy);
        restTemplate.setRequestFactory((ClientHttpRequestFactory)requestFactory);
    }

    public static void downloadDir(String fileURL, String dir) throws Exception {
        String urlResourcesName = fileURL.substring(fileURL.lastIndexOf("/") + 1);
        DownloadUtil.download(fileURL, dir + File.separator + urlResourcesName);
    }

    public static void downloadFile(String fileURL, String dir, String fileName) throws Exception {
        DownloadUtil.download(fileURL, dir + File.separator + fileName);
    }

    public static void download(String fileURL, String fileFullPath) throws Exception {
        DownloadUtil.download(fileURL, fileFullPath, null);
    }

    public static void download(String fileURL, String fileFullPath, Map<String, String> headerMaps) throws Exception {
        File file = new File(fileFullPath);
        boolean mkdirs = file.getParentFile().mkdirs();
        if (mkdirs) {
            log.info("auto create directory \uff1a{}", (Object)file.getParentFile().getAbsolutePath());
        }
        HttpHeaders headers = new HttpHeaders();
        if (headerMaps != null && headerMaps.size() > 0) {
            headerMaps.forEach((arg_0, arg_1) -> ((HttpHeaders)headers).add(arg_0, arg_1));
        }
        HttpEntity requestEntity = new HttpEntity(null, (MultiValueMap)headers);
        ByteArrayResponseExtractor byteArrayResponseExtractor = new ByteArrayResponseExtractor(downloadProgressPrinter);
        RequestCallback requestCallback = restTemplate.httpEntityCallback((Object)requestEntity, ByteArrayResponseExtractor.class);
        byte[] body = (byte[])restTemplate.execute(fileURL, HttpMethod.GET, requestCallback, (ResponseExtractor)byteArrayResponseExtractor, new Object[0]);
        Files.write(Paths.get(fileFullPath, new String[0]), Objects.requireNonNull(body), new OpenOption[0]);
    }

    public static void downloadUseHutool(String url, String dir, String fileName) {
        if (fileName == null || fileName.length() == 0) {
            fileName = UrlUtil.getName(url);
        }
        HttpResponse response = HttpUtil.createGet((String)url, (boolean)true).setProxy(proxy).timeout(600000).executeAsync();
        File file = response.completeFileNameFromHeader(new File(dir, fileName));
        response.writeBody(file);
    }

    public static void downloadUseJdk(String url, String dir, String fileName) throws Exception {
        if (fileName == null || fileName.length() == 0) {
            fileName = UrlUtil.getName(url);
        }
        URL downloadUrl = new URL(url);
        URLConnection connection = proxy != null ? downloadUrl.openConnection(proxy) : downloadUrl.openConnection();
        connection.setConnectTimeout(60000);
        connection.setReadTimeout(60000);
        InputStream in = connection.getInputStream();
        File file = new File(dir);
        if (!file.exists()) {
            boolean bl = file.mkdirs();
        }
        FileOutputStream out = new FileOutputStream(file + "\\" + fileName);
        IOUtils.copyLarge((InputStream)in, (OutputStream)out);
        out.flush();
        in.close();
        out.close();
    }

    public static void downloadMultiFile(List<String> sourceUrls, String dir, int threadNum, Task task) {
        ExecutorService executorService = Executors.newFixedThreadPool(threadNum);
        ArrayList futureList = new ArrayList();
        WorkUtil.watch(() -> {
            log.info("\u591a\u7ebf\u7a0b\u4e0b\u8f7d\u4efb\u52a1\u6267\u884c\u5f00\u59cb -> \u4efb\u52a1\u6570\uff1a{} \u7ebf\u7a0b\u6570\uff1a{}", (Object)sourceUrls.size(), (Object)threadNum);
            for (String sourceUrl : sourceUrls) {
                CompletableFuture<Void> completableFuture = CompletableFuture.runAsync(() -> {
                    try {
                        ThreadPoolExecutor executor = (ThreadPoolExecutor)executorService;
                        log.info("\u5f53\u524d\u4e0b\u8f7d\uff1a{} \u5269\u4f59\u4efb\u52a1\uff1a{}", (Object)sourceUrl, (Object)executor.getQueue().size());
                        WorkUtil.doRetryWork(3, () -> DownloadUtil.downloadUseHutool(sourceUrl, dir, null));
                    }
                    catch (Exception e) {
                        log.error(e.getMessage(), (Throwable)e);
                    }
                }, executorService);
                futureList.add(completableFuture);
            }
            CompletableFuture<Void> completableFuture = CompletableFuture.allOf(futureList.toArray(new CompletableFuture[0]));
            completableFuture.whenComplete((o, e) -> task.run());
            completableFuture.join();
            executorService.shutdown();
            log.info("\u591a\u7ebf\u7a0b\u4e0b\u8f7d\u4efb\u52a1\u6267\u884c\u7ed3\u675f");
        });
    }

    public static void downloadMultiFile(List<String> sourceUrls, String dir, Consumer<Integer> progressTask, long progressLimit, Task completeTask, ThreadPoolExecutor executor) {
        ArrayList futureList = new ArrayList();
        WorkUtil.watch(() -> {
            log.info("\u591a\u7ebf\u7a0b\u4e0b\u8f7d\u4efb\u52a1\u6267\u884c\u5f00\u59cb -> \u4efb\u52a1\u6570\uff1a{} \u7ebf\u7a0b\u6570\uff1a{}", (Object)sourceUrls.size(), (Object)executor.getCorePoolSize());
            AtomicInteger downloadedCount = new AtomicInteger();
            long[] lastTimeMillis = new long[]{System.currentTimeMillis()};
            for (String sourceUrl : sourceUrls) {
                CompletableFuture<Void> completableFuture = CompletableFuture.runAsync(() -> {
                    try {
                        long currentTimeMillis;
                        int perm = (int)Calculator.conversion((String)(downloadedCount.getAndIncrement() + " / " + sourceUrls.size() + "*100"));
                        log.info("\u5f53\u524d\u4e0b\u8f7d\uff1a{} -> {} \u5269\u4f59\u4efb\u52a1\uff1a{}  \u8fdb\u5ea6\uff1a{}%", new Object[]{sourceUrl, dir, executor.getQueue().size(), perm});
                        WorkUtil.doRetryWork(3, () -> DownloadUtil.downloadUseHutool(sourceUrl, dir, null));
                        if (progressTask != null && (currentTimeMillis = System.currentTimeMillis()) - lastTimeMillis[0] > progressLimit) {
                            lastTimeMillis[0] = currentTimeMillis;
                            progressTask.accept(perm);
                        }
                    }
                    catch (Exception e) {
                        log.error(e.getMessage(), (Throwable)e);
                    }
                }, executor);
                futureList.add(completableFuture);
            }
            CompletableFuture<Void> completableFuture = CompletableFuture.allOf(futureList.toArray(new CompletableFuture[0]));
            completableFuture.whenComplete((o, e) -> {
                if (progressTask != null) {
                    progressTask.accept(100);
                }
                completeTask.run();
            });
            completableFuture.join();
            log.info("\u591a\u7ebf\u7a0b\u4e0b\u8f7d\u4efb\u52a1\u6267\u884c\u7ed3\u675f");
        });
    }
}

