/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.downloader.ext;

import cn.acyou.leo.framework.downloader.ext.DownloadProgressMonitor;
import cn.acyou.leo.framework.downloader.support.DownloadProgressPrinter;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.web.client.ResponseExtractor;

public abstract class AbstractDownloadProgressMonitorResponseExtractor<T>
implements ResponseExtractor<T>,
DownloadProgressMonitor {
    private static final Logger log = LoggerFactory.getLogger(AbstractDownloadProgressMonitorResponseExtractor.class);
    protected DownloadProgressPrinter downloadProgressPrinter;

    public AbstractDownloadProgressMonitorResponseExtractor(DownloadProgressPrinter downloadProgressPrinter) {
        this.downloadProgressPrinter = downloadProgressPrinter;
    }

    public AbstractDownloadProgressMonitorResponseExtractor() {
        this.downloadProgressPrinter = DownloadProgressPrinter.defaultDownloadProgressPrinter();
    }

    public T extractData(ClientHttpResponse response) throws IOException {
        long contentLength = response.getHeaders().getContentLength();
        this.calculateDownloadProgress(contentLength);
        return this.doExtractData(response);
    }

    protected abstract T doExtractData(ClientHttpResponse var1) throws IOException;

    @Override
    public void calculateDownloadProgress(long contentLength) {
        long totalSize = contentLength / 1024L;
        String task = this.getTask();
        CompletableFuture.runAsync(() -> {
            long tmp = 0L;
            while (contentLength - tmp > 0L) {
                long speed = this.getAlreadyDownloadLength() - tmp;
                tmp = this.getAlreadyDownloadLength();
                this.downloadProgressPrinter.print(task, totalSize, tmp, speed);
                this.sleep();
            }
        }).exceptionally(e -> {
            log.error(e.getMessage(), e);
            return null;
        });
    }

    protected String getTask() {
        return Thread.currentThread().getName();
    }

    private void sleep() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

