/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.util;

import cn.acyou.leo.framework.util.NumberUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collections;
import java.util.List;
import java.util.Stack;

public class Calculator {
    private BigDecimal result;
    private final Stack<String> postfixStack = new Stack();
    private final Stack<Character> opStack = new Stack();
    private final int[] operatPriority = new int[]{0, 3, 2, 1, -1, 1, 0, 2};

    public static Calculator val(Object v) {
        return new Calculator(v.toString());
    }

    private Calculator(String v) {
        this.result = new BigDecimal(v);
    }

    public boolean gt(Object compareValue) {
        return this.result.compareTo(new BigDecimal(compareValue.toString())) > 0;
    }

    public boolean gte(Object compareValue) {
        return this.result.compareTo(new BigDecimal(compareValue.toString())) >= 0;
    }

    public boolean lt(Object compareValue) {
        return this.result.compareTo(new BigDecimal(compareValue.toString())) < 0;
    }

    public boolean lte(Object compareValue) {
        return this.result.compareTo(new BigDecimal(compareValue.toString())) <= 0;
    }

    public boolean eq(Object compareValue) {
        return this.result.compareTo(new BigDecimal(compareValue.toString())) == 0;
    }

    public boolean neq(Object compareValue) {
        return this.result.compareTo(new BigDecimal(compareValue.toString())) != 0;
    }

    public static BigDecimal avg(List<BigDecimal> values, int scale, RoundingMode roundingMode) {
        if (values == null || values.isEmpty()) {
            return BigDecimal.ZERO;
        }
        BigDecimal total = new BigDecimal("0");
        for (BigDecimal val : values) {
            total = total.add(val);
        }
        return total.divide(new BigDecimal(values.size()), scale, roundingMode);
    }

    public BigDecimal getResult() {
        return this.result;
    }

    public BigDecimal add(Object v) {
        return this.result.add(new BigDecimal(v.toString()));
    }

    public BigDecimal subtract(Object v) {
        return this.result.subtract(new BigDecimal(v.toString()));
    }

    public BigDecimal multiply(Object v) {
        return this.result.multiply(new BigDecimal(v.toString()));
    }

    public BigDecimal divide(Object v, int scale, RoundingMode roundingMode) {
        return this.result.divide(new BigDecimal(v.toString()), scale, roundingMode);
    }

    public BigDecimal divide(Object v) {
        return this.result.divide(new BigDecimal(v.toString()), 2, RoundingMode.FLOOR);
    }

    public BigDecimal divide_10_HALF_UP(Object v) {
        return this.result.divide(new BigDecimal(v.toString()), 2, RoundingMode.HALF_UP);
    }

    public BigDecimal divide_10_FLOOR(Object v) {
        return this.result.divide(new BigDecimal(v.toString()), 10, RoundingMode.FLOOR);
    }

    public String toString() {
        return "Calculator{result=" + this.result + '}';
    }

    public static BigDecimal conversion(String expression) {
        Calculator cal = new Calculator("0");
        expression = expression.replaceAll(" ", "");
        expression = Calculator.transform(expression);
        return cal.calculate(expression);
    }

    public BigDecimal calculate(String expression) {
        Stack<String> resultStack = new Stack<String>();
        this.prepare(expression);
        Collections.reverse(this.postfixStack);
        while (!this.postfixStack.isEmpty()) {
            String currentValue = this.postfixStack.pop();
            if (!this.isOperator(currentValue.charAt(0))) {
                currentValue = currentValue.replace("~", "-");
                resultStack.push(currentValue);
                continue;
            }
            String secondValue = (String)resultStack.pop();
            String firstValue = (String)resultStack.pop();
            firstValue = firstValue.replace("~", "-");
            secondValue = secondValue.replace("~", "-");
            BigDecimal tempResult = this.calculate(firstValue, secondValue, currentValue.charAt(0));
            resultStack.push(tempResult.toString());
        }
        this.result = new BigDecimal((String)resultStack.pop());
        return this.result;
    }

    private boolean isOperator(char c) {
        return c == '+' || c == '-' || c == '*' || c == '/' || c == '(' || c == ')';
    }

    public boolean compare(char cur, char peek) {
        return this.operatPriority[peek - 40] >= this.operatPriority[cur - 40];
    }

    private void prepare(String expression) {
        this.opStack.push(Character.valueOf(','));
        char[] arr = expression.toCharArray();
        int currentIndex = 0;
        int count = 0;
        for (int i = 0; i < arr.length; ++i) {
            char currentOp = arr[i];
            if (this.isOperator(currentOp)) {
                if (count > 0) {
                    this.postfixStack.push(new String(arr, currentIndex, count));
                }
                char peekOp = this.opStack.peek().charValue();
                if (currentOp == ')') {
                    while (this.opStack.peek().charValue() != '(') {
                        this.postfixStack.push(String.valueOf(this.opStack.pop()));
                    }
                    this.opStack.pop();
                } else {
                    while (currentOp != '(' && peekOp != ',' && this.compare(currentOp, peekOp)) {
                        this.postfixStack.push(String.valueOf(this.opStack.pop()));
                        peekOp = this.opStack.peek().charValue();
                    }
                    this.opStack.push(Character.valueOf(currentOp));
                }
                count = 0;
                currentIndex = i + 1;
                continue;
            }
            ++count;
        }
        if (count > 1 || count == 1 && !this.isOperator(arr[currentIndex])) {
            this.postfixStack.push(new String(arr, currentIndex, count));
        }
        while (this.opStack.peek().charValue() != ',') {
            this.postfixStack.push(String.valueOf(this.opStack.pop()));
        }
    }

    private static String transform(String expression) {
        char[] arr = expression.toCharArray();
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] != '-') continue;
            if (i == 0) {
                arr[i] = 126;
                continue;
            }
            char c = arr[i - 1];
            if (c != '+' && c != '-' && c != '*' && c != '/' && c != '(' && c != 'E' && c != 'e') continue;
            arr[i] = 126;
        }
        if (arr[0] == '~' || arr.length > 1 && arr[1] == '(') {
            arr[0] = 45;
            return "0" + new String(arr);
        }
        return new String(arr);
    }

    private BigDecimal calculate(String firstValue, String secondValue, char currentOp) {
        BigDecimal result;
        switch (currentOp) {
            case '+': {
                result = NumberUtil.add(firstValue, secondValue);
                break;
            }
            case '-': {
                result = NumberUtil.sub(firstValue, secondValue);
                break;
            }
            case '*': {
                result = NumberUtil.mul(firstValue, secondValue);
                break;
            }
            case '/': {
                result = NumberUtil.div(firstValue, secondValue);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + currentOp);
            }
        }
        return result;
    }
}

