/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.util;

import cn.acyou.leo.framework.exception.ServiceException;
import cn.acyou.leo.framework.util.StringUtils;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageOutputStream;

public class ImageUtil {
    public static BufferedImage read(File input) {
        try {
            return ImageIO.read(input);
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
    }

    public static BufferedImage read(InputStream input) {
        try {
            return ImageIO.read(input);
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
    }

    public static BufferedImage read(String url) {
        return StringUtils.isHttpUrl(url) ? ImageUtil.readUrl(url) : ImageUtil.read(new File(url));
    }

    private static BufferedImage readUrl(String url) {
        try {
            return ImageIO.read(new URL(url));
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
    }

    public static BufferedImage read(URL url) {
        try {
            return ImageIO.read(url);
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
    }

    public static boolean write(RenderedImage im, String formatName, ImageOutputStream output) {
        try {
            return ImageIO.write(im, formatName, output);
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
    }

    public static boolean write(RenderedImage im, String formatName, File output) {
        try {
            return ImageIO.write(im, formatName, output);
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
    }

    public static boolean write(RenderedImage im, String formatName, OutputStream output) {
        try {
            return ImageIO.write(im, formatName, output);
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] writeAsBytes(RenderedImage im, String formatName) {
        try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
            if (ImageIO.write(im, formatName, output)) {
                byte[] byArray = output.toByteArray();
                return byArray;
            }
            throw new IllegalArgumentException("ImageWriter formatName " + formatName + " writer is null.");
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
    }

    public static ByteArrayInputStream writeAsStream(RenderedImage im, String formatName) {
        return new ByteArrayInputStream(ImageUtil.writeAsBytes(im, formatName));
    }
}

