/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONUtil {
    private static final Logger log = LoggerFactory.getLogger(JSONUtil.class);

    public static String getByKey(String str, String key) {
        if (StringUtils.isNotBlank((CharSequence)str)) {
            try {
                JSONObject jsonObject = JSON.parseObject((String)str);
                return jsonObject.getString(key);
            }
            catch (Exception e) {
                log.error("\u89e3\u6790JSON\u51fa\u9519", (Throwable)e);
            }
        }
        return null;
    }

    public static <T> T getObjectByKey(String str, String key) {
        if (StringUtils.isNotBlank((CharSequence)str)) {
            try {
                JSONObject jsonObject = JSON.parseObject((String)str);
                return (T)jsonObject.get((Object)key);
            }
            catch (Exception e) {
                log.info("\u83b7\u53d6\u5c5e\u6027\u51fa\u9519", (Throwable)e);
            }
        }
        return null;
    }

    public static String setByKey(String str, String key, Object val) {
        JSONObject obj = new JSONObject();
        if (StringUtils.isNotBlank((CharSequence)str)) {
            try {
                obj = JSON.parseObject((String)str);
            }
            catch (Exception e) {
                log.error("\u89e3\u6790JSON\u51fa\u9519", (Throwable)e);
            }
        }
        obj.put(key, val);
        return obj.toJSONString();
    }
}

