/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.util;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SHAUtil {
    private static final Logger log = LoggerFactory.getLogger(SHAUtil.class);
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final Charset UTF8_CHARSET = StandardCharsets.UTF_8;

    public static String getSHA1(String ... strs) {
        Arrays.sort(strs);
        StringBuilder content = new StringBuilder();
        for (String s : strs) {
            content.append(s);
        }
        return SHAUtil.getSHA1(content.toString());
    }

    public static String getSHA1(String token, String timestamp, String nonce) {
        Object[] arr = new String[]{token, timestamp, nonce};
        Arrays.sort(arr);
        StringBuilder content = new StringBuilder();
        for (Object s : arr) {
            content.append((String)s);
        }
        return SHAUtil.getSHA1(content.toString());
    }

    public static String getSHA1(String data) {
        byte[] dataBytes = SHAUtil.getDigest("SHA-1").digest(data.getBytes(UTF8_CHARSET));
        return new String(SHAUtil.encodeHex(dataBytes));
    }

    public static String getMD5(String data) {
        byte[] dataBytes = SHAUtil.getDigest("MD5").digest(data.getBytes(UTF8_CHARSET));
        return new String(SHAUtil.encodeHex(dataBytes));
    }

    public static String getSHA256(String data) {
        byte[] dataBytes = SHAUtil.getDigest("SHA-256").digest(data.getBytes(UTF8_CHARSET));
        return new String(SHAUtil.encodeHex(dataBytes));
    }

    private static char[] encodeHex(byte[] data) {
        int l = data.length;
        char[] out = new char[l << 1];
        int j = 0;
        for (int i = 0; i < l; ++i) {
            out[j++] = HEX_CHARS[(0xF0 & data[i]) >>> 4];
            out[j++] = HEX_CHARS[0xF & data[i]];
        }
        return out;
    }

    private static MessageDigest getDigest(String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IllegalStateException("Could not find MessageDigest with algorithm \"" + algorithm + "\"", ex);
        }
    }
}

