/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.util;

import cn.acyou.leo.framework.model.TreeNode;
import cn.acyou.leo.framework.util.CollectionUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class TreeUtil {
    public static <E extends TreeNode<?, E>> List<E> buildTrees(List<E> nodes) {
        ArrayList<TreeNode> rootNodes = new ArrayList<TreeNode>();
        Iterator<E> ite = nodes.iterator();
        while (ite.hasNext()) {
            TreeNode node = (TreeNode)ite.next();
            if (!node.root()) continue;
            rootNodes.add(node);
            ite.remove();
        }
        rootNodes.forEach(r -> TreeUtil.setChildren(r, nodes));
        return rootNodes;
    }

    private static <E extends TreeNode<?, E>> void setChildren(E parent, List<E> nodes) {
        ArrayList<TreeNode> children = new ArrayList<TreeNode>();
        Object parentId = parent.id();
        Iterator<E> ite = nodes.iterator();
        while (ite.hasNext()) {
            TreeNode node = (TreeNode)ite.next();
            if (!Objects.equals(node.parentId(), parentId)) continue;
            children.add(node);
            ite.remove();
        }
        if (CollectionUtils.isNotEmpty(children)) {
            parent.children(children);
            children.forEach(m -> TreeUtil.setChildren(m, nodes));
        }
    }
}

