/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.util;

import cn.acyou.leo.framework.util.IOUtil;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipUtil {
    private static final Logger log = LoggerFactory.getLogger(ZipUtil.class);

    public static void zipBatch(String[] fileNames, InputStream[] srcFiles, OutputStream destStream) throws Exception {
        log.info("\u538b\u7f29\u5f00\u59cb\u538b\u7f29...");
        ZipOutputStream zos = new ZipOutputStream(destStream, Charset.forName("GBK"));
        for (int k = 0; k < srcFiles.length; ++k) {
            ZipEntry ze = new ZipEntry(fileNames[k]);
            ze.setSize(srcFiles.length);
            ze.setTime(new Date().getTime());
            log.info("\u6b63\u5728\u538b\u7f29\u7b2c" + k + "\u4e2a\u8f93\u5165\u6d41!");
            zos.putNextEntry(ze);
            BufferedInputStream is = new BufferedInputStream(srcFiles[k]);
            IOUtil.copyLarge(is, zos);
            is.close();
        }
        zos.close();
        log.info("\u538b\u7f29\u5b8c\u6bd5\uff01");
    }
}

