/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.util.component;

import cn.acyou.leo.framework.prop.DingTalkProperty;
import cn.acyou.leo.framework.prop.DingTalkRobot;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DingTalkUtil {
    private static final Logger log = LoggerFactory.getLogger(DingTalkUtil.class);
    private final Map<String, DingTalkRobot> dingTalkRobotMap;

    public DingTalkUtil(DingTalkProperty dingTalkProperty) {
        this.dingTalkRobotMap = dingTalkProperty.getDingTalkRobotMap();
    }

    public void sendMessage(String groupId, List<String> atMobileList, String content) {
        DingTalkRobot dingTalkRobot = this.dingTalkRobotMap.get(groupId);
        if (dingTalkRobot == null) {
            log.warn("\u672a\u627e\u5230\u673a\u5668\u4eba\uff1a{}", (Object)groupId);
            return;
        }
        LinkedHashMap<String, String> contentMap = new LinkedHashMap<String, String>();
        contentMap.put("content", content);
        LinkedHashMap<String, Object> atMap = new LinkedHashMap<String, Object>();
        atMap.put("isAtAll", dingTalkRobot.getAtAll());
        atMap.put("atMobiles", atMobileList);
        LinkedHashMap<String, Object> reqMap = new LinkedHashMap<String, Object>();
        reqMap.put("msgtype", "text");
        reqMap.put("text", contentMap);
        reqMap.put("at", atMap);
        Long timestamp = System.currentTimeMillis();
        String url = dingTalkRobot.getRobotHookUrl() + "&timestamp=" + timestamp + "&sign=" + this.getSignature(dingTalkRobot.getRobotSecret(), timestamp);
        log.info("\u51c6\u5907\u53d1\u9001\u9489\u9489\u6d88\u606f\uff1a{}", (Object)url);
        String res = HttpUtil.post((String)url, (String)JSON.toJSONString(reqMap));
        log.info("\u53d1\u9001\u9489\u9489\u6d88\u606f\u7ed3\u679c:{}", (Object)res);
    }

    private String getSignature(String secret, Long timestamp) {
        String signa = "";
        try {
            String stringToSign = timestamp + "\n" + secret;
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(new SecretKeySpec(secret.getBytes(StandardCharsets.UTF_8), "HmacSHA256"));
            byte[] signData = mac.doFinal(stringToSign.getBytes(StandardCharsets.UTF_8));
            signa = URLEncoder.encode(new String(Base64.encodeBase64((byte[])signData)), "UTF-8");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return signa;
    }
}

