/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.aspect;

import cn.acyou.leo.framework.annotation.AutoIdempotent;
import cn.acyou.leo.framework.constant.CommonErrorEnum;
import cn.acyou.leo.framework.exception.ServiceException;
import cn.acyou.leo.framework.util.redis.RedisUtils;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
public class AutoIdempotentAspect {
    private static final Logger log = LoggerFactory.getLogger(AutoIdempotentAspect.class);
    @Autowired
    private RedisUtils redisUtils;

    @Pointcut(value="@annotation(autoIdempotent)")
    public void pointCut(AutoIdempotent autoIdempotent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="pointCut(autoIdempotent)")
    public Object around(ProceedingJoinPoint joinPoint, AutoIdempotent autoIdempotent) throws Throwable {
        String prefix = autoIdempotent.prefix();
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        assert (requestAttributes != null);
        HttpServletRequest request = requestAttributes.getRequest();
        String sequence = request.getParameter("sequence");
        if (StringUtils.hasText((String)sequence)) {
            String key = "LEO:AUTO_IDEMPOTENT_SEQUENCE:" + prefix + sequence;
            String v = null;
            try {
                v = this.redisUtils.get(key);
                if (!StringUtils.hasText((String)v)) {
                    throw new ServiceException(CommonErrorEnum.REPETITIVE_OPERATION);
                }
                Object object = joinPoint.proceed();
                return object;
            }
            finally {
                this.redisUtils.delete(key);
            }
        }
        return joinPoint.proceed();
    }
}

