/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.aspect;

import cn.acyou.leo.framework.base.ClientLanguage;
import cn.acyou.leo.framework.context.AppContext;
import cn.acyou.leo.framework.model.Internationalized;
import cn.acyou.leo.framework.model.PageData;
import cn.acyou.leo.framework.model.Result;
import cn.acyou.leo.framework.util.CollectionUtils;
import cn.acyou.leo.framework.util.ReflectUtils;
import cn.acyou.leo.framework.util.StringUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.List;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.ReflectionUtils;

@Aspect
@Component
public class InternationalizedAspect {
    private static final Logger log = LoggerFactory.getLogger(InternationalizedAspect.class);

    @Pointcut(value="@within(org.springframework.stereotype.Controller)")
    public void pointCutCtl() {
    }

    @Pointcut(value="@within(org.springframework.web.bind.annotation.RestController)")
    public void pointCutRestCtl() {
    }

    @Around(value="pointCutCtl() || pointCutRestCtl()")
    public Object around(ProceedingJoinPoint joinPoint) throws Throwable {
        Object proceed = joinPoint.proceed();
        try {
            if (proceed instanceof Result) {
                Collection collection;
                List list;
                Result r = (Result)proceed;
                Object data = r.getData();
                if (data instanceof Internationalized) {
                    this.processInternationalizedData((Internationalized)data);
                }
                if (data instanceof PageData && CollectionUtils.isNotEmpty(list = ((PageData)data).getList()) && list.get(0) instanceof Internationalized) {
                    for (Object datum : list) {
                        this.processInternationalizedData((Internationalized)datum);
                    }
                }
                if (data instanceof Collection && CollectionUtils.isNotEmpty(collection = (Collection)data) && collection.stream().findFirst().get() instanceof Internationalized) {
                    for (Object datum : (Collection)data) {
                        this.processInternationalizedData((Internationalized)datum);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return proceed;
    }

    public void processInternationalizedData(Internationalized obj) {
        String internationalLang = obj.getInternationalLang();
        if (StringUtils.isNotBlank((CharSequence)internationalLang)) {
            JSONObject jsonObject = JSON.parseObject((String)internationalLang);
            ClientLanguage clientLanguage = AppContext.getClientLanguage();
            String clientLanguageName = clientLanguage.getName();
            ReflectionUtils.doWithFields(obj.getClass(), t -> {
                String fieldName = t.getName();
                String v = jsonObject.getString(fieldName + "_" + clientLanguageName);
                if (StringUtils.isNotBlank((CharSequence)v)) {
                    ReflectUtils.setFieldValue(t, (Object)obj, (Object)v);
                }
            });
        }
    }
}

