/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.aspect;

import cn.acyou.leo.framework.annotation.authz.Logical;
import cn.acyou.leo.framework.annotation.authz.RequiresLogin;
import cn.acyou.leo.framework.annotation.authz.RequiresPermissions;
import cn.acyou.leo.framework.annotation.authz.RequiresRoles;
import cn.acyou.leo.framework.base.LoginUser;
import cn.acyou.leo.framework.constant.CommonErrorEnum;
import cn.acyou.leo.framework.context.AppContext;
import cn.acyou.leo.framework.exception.ServiceException;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Set;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.PatternMatchUtils;
import org.springframework.util.StringUtils;

@Aspect
@Component
public class PermissionsAspect {
    private static final Logger log = LoggerFactory.getLogger(PermissionsAspect.class);
    private static final String ALL_PERMISSION = "*:*:*";

    @Around(value="@annotation(cn.acyou.leo.framework.annotation.authz.RequiresLogin) || @annotation(cn.acyou.leo.framework.annotation.authz.RequiresRoles) || @annotation(cn.acyou.leo.framework.annotation.authz.RequiresPermissions)")
    public Object around(ProceedingJoinPoint joinPoint) throws Throwable {
        boolean containsAny;
        boolean containsAll;
        Logical logical;
        LoginUser loginUser;
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        RequiresLogin requiresLogin = methodSignature.getMethod().getAnnotation(RequiresLogin.class);
        RequiresRoles requiresRoles = methodSignature.getMethod().getAnnotation(RequiresRoles.class);
        RequiresPermissions requiresPermissions = methodSignature.getMethod().getAnnotation(RequiresPermissions.class);
        if (requiresLogin != null && (loginUser = AppContext.getLoginUser()) == null) {
            throw new ServiceException(CommonErrorEnum.E_UNAUTHENTICATED);
        }
        if (requiresRoles != null) {
            loginUser = AppContext.getLoginUser();
            if (loginUser == null) {
                throw new ServiceException(CommonErrorEnum.E_UNAUTHENTICATED);
            }
            Set<String> roleCodes = loginUser.getRoleCodes();
            logical = requiresRoles.logical();
            Object[] needRoles = requiresRoles.value();
            if (logical.equals((Object)Logical.AND) && !(containsAll = roleCodes.containsAll(Sets.newHashSet((Object[])needRoles)))) {
                throw new ServiceException(CommonErrorEnum.E_INSUFFICIENT_PERMISSIONS);
            }
            if (logical.equals((Object)Logical.OR) && !(containsAny = CollectionUtils.containsAny(roleCodes, (Collection)Sets.newHashSet((Object[])needRoles)))) {
                throw new ServiceException(CommonErrorEnum.E_INSUFFICIENT_PERMISSIONS);
            }
        }
        if (requiresPermissions != null) {
            loginUser = AppContext.getLoginUser();
            if (loginUser == null) {
                throw new ServiceException(CommonErrorEnum.E_UNAUTHENTICATED);
            }
            Set<String> permsList = loginUser.getPermsList();
            logical = requiresPermissions.logical();
            String[] needPermissions = requiresPermissions.value();
            if (logical.equals((Object)Logical.AND) && !(containsAll = this.checkPermsAnd(permsList, needPermissions))) {
                throw new ServiceException(CommonErrorEnum.E_INSUFFICIENT_PERMISSIONS);
            }
            if (logical.equals((Object)Logical.OR) && !(containsAny = this.checkPermsOr(permsList, needPermissions))) {
                throw new ServiceException(CommonErrorEnum.E_INSUFFICIENT_PERMISSIONS);
            }
        }
        return joinPoint.proceed();
    }

    public boolean checkPermsAnd(Set<String> permissionList, String ... permissions) {
        for (String permission : permissions) {
            if (this.hasPermi(permissionList, permission)) continue;
            return false;
        }
        return true;
    }

    public boolean checkPermsOr(Set<String> permissionList, String ... permissions) {
        for (String permission : permissions) {
            if (!this.hasPermi(permissionList, permission)) continue;
            return true;
        }
        return permissions.length <= 0;
    }

    public boolean hasPermi(Collection<String> authorities, String permission) {
        return authorities.stream().filter(StringUtils::hasText).anyMatch(x -> ALL_PERMISSION.contains((CharSequence)x) || PatternMatchUtils.simpleMatch((String)x, (String)permission));
    }
}

