/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.base;

import org.springframework.util.StringUtils;

public enum ClientLanguage {
    CHINESE("zh", 0),
    ENGLISH("en", 1),
    JAPANESE("jp", 2);

    private final String name;
    private final int index;

    private ClientLanguage(String name, int index) {
        this.name = name;
        this.index = index;
    }

    public static ClientLanguage getLanguage(String language) {
        if (!StringUtils.hasText((String)language)) {
            return CHINESE;
        }
        for (ClientLanguage value : ClientLanguage.values()) {
            if (!value.getName().equals(language)) continue;
            return value;
        }
        return CHINESE;
    }

    public String getName() {
        return this.name;
    }

    public int getIndex() {
        return this.index;
    }
}

