/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.base;

import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class ColorVo
implements Serializable {
    private static final long serialVersionUID = 7691135714124230831L;
    @ApiModelProperty(value="\u7ea2 0~255")
    private int red;
    @ApiModelProperty(value="\u7eff 0~255")
    private int green;
    @ApiModelProperty(value="\u84dd 0~255")
    private int blue;
    @ApiModelProperty(value="\u900f\u660e\u5ea6 0~255")
    private int alpha;
    @ApiModelProperty(value="\u7ea2 16\u8fdb\u5236")
    private String redHex;
    @ApiModelProperty(value="\u7eff 16\u8fdb\u52365")
    private String greenHex;
    @ApiModelProperty(value="\u84dd 16\u8fdb\u5236")
    private String blueHex;
    @ApiModelProperty(value="\u900f\u660e\u5ea6 16\u8fdb\u5236")
    private String alphaHex;
    @ApiModelProperty(value="\u900f\u660e\u5ea6 \u6bd4\u4f8b\uff1a0.78")
    private String alphaRatio;
    @ApiModelProperty(value="rgb \u989c\u8272\u503c")
    private String rgbColor;
    @ApiModelProperty(value="rgba \u989c\u8272\u503c")
    private String rgbaColor;
    @ApiModelProperty(value="10\u8fdb\u5236\u989c\u8272\u503c\uff08\u65e0\u900f\u660e\uff09")
    private Integer decimalColor;
    @ApiModelProperty(value="16\u8fdb\u5236\u989c\u8272\u503c\uff08\u65e0\u900f\u660e\uff09")
    private String hexColor;
    @ApiModelProperty(value="16\u8fdb\u5236\u989c\u8272\u503c\uff08\u6709\u900f\u660e\uff09")
    private String hexColorAlpha;

    public ColorVo(int red, int green, int blue) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.alpha = 255;
        this.afterSet();
    }

    public ColorVo(int red, int green, int blue, int alpha) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.alpha = alpha;
        this.afterSet();
    }

    private void afterSet() {
        this.redHex = Integer.toHexString(this.red).length() == 1 ? "0" + Integer.toHexString(this.red) : Integer.toHexString(this.red);
        this.greenHex = Integer.toHexString(this.green).length() == 1 ? "0" + Integer.toHexString(this.green) : Integer.toHexString(this.green);
        this.blueHex = Integer.toHexString(this.blue).length() == 1 ? "0" + Integer.toHexString(this.blue) : Integer.toHexString(this.blue);
        this.alphaHex = Integer.toHexString(this.alpha).length() == 1 ? "0" + Integer.toHexString(this.alpha) : Integer.toHexString(this.alpha);
        this.alphaRatio = new BigDecimal(this.alpha + "").divide(new BigDecimal("255"), 2, RoundingMode.FLOOR).toString();
        this.rgbColor = String.format("%s,%s,%s", this.red, this.green, this.blue);
        this.rgbaColor = String.format("%s,%s,%s,%s", this.red, this.green, this.blue, this.alphaRatio);
        this.hexColor = "#" + this.redHex + this.greenHex + this.blueHex;
        this.hexColorAlpha = "#" + this.redHex + this.greenHex + this.blueHex + this.alphaHex;
        this.decimalColor = Integer.parseInt(this.redHex + this.greenHex + this.blueHex, 16);
    }

    public int getRed() {
        return this.red;
    }

    public int getGreen() {
        return this.green;
    }

    public int getBlue() {
        return this.blue;
    }

    public int getAlpha() {
        return this.alpha;
    }

    public String getRedHex() {
        return this.redHex;
    }

    public String getGreenHex() {
        return this.greenHex;
    }

    public String getBlueHex() {
        return this.blueHex;
    }

    public String getAlphaHex() {
        return this.alphaHex;
    }

    public String getAlphaRatio() {
        return this.alphaRatio;
    }

    public String getRgbColor() {
        return this.rgbColor;
    }

    public String getRgbaColor() {
        return this.rgbaColor;
    }

    public Integer getDecimalColor() {
        return this.decimalColor;
    }

    public String getHexColor() {
        return this.hexColor;
    }

    public String getHexColorAlpha() {
        return this.hexColorAlpha;
    }

    public void setRed(int red) {
        this.red = red;
    }

    public void setGreen(int green) {
        this.green = green;
    }

    public void setBlue(int blue) {
        this.blue = blue;
    }

    public void setAlpha(int alpha) {
        this.alpha = alpha;
    }

    public void setRedHex(String redHex) {
        this.redHex = redHex;
    }

    public void setGreenHex(String greenHex) {
        this.greenHex = greenHex;
    }

    public void setBlueHex(String blueHex) {
        this.blueHex = blueHex;
    }

    public void setAlphaHex(String alphaHex) {
        this.alphaHex = alphaHex;
    }

    public void setAlphaRatio(String alphaRatio) {
        this.alphaRatio = alphaRatio;
    }

    public void setRgbColor(String rgbColor) {
        this.rgbColor = rgbColor;
    }

    public void setRgbaColor(String rgbaColor) {
        this.rgbaColor = rgbaColor;
    }

    public void setDecimalColor(Integer decimalColor) {
        this.decimalColor = decimalColor;
    }

    public void setHexColor(String hexColor) {
        this.hexColor = hexColor;
    }

    public void setHexColorAlpha(String hexColorAlpha) {
        this.hexColorAlpha = hexColorAlpha;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ColorVo)) {
            return false;
        }
        ColorVo other = (ColorVo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getRed() != other.getRed()) {
            return false;
        }
        if (this.getGreen() != other.getGreen()) {
            return false;
        }
        if (this.getBlue() != other.getBlue()) {
            return false;
        }
        if (this.getAlpha() != other.getAlpha()) {
            return false;
        }
        Integer this$decimalColor = this.getDecimalColor();
        Integer other$decimalColor = other.getDecimalColor();
        if (this$decimalColor == null ? other$decimalColor != null : !((Object)this$decimalColor).equals(other$decimalColor)) {
            return false;
        }
        String this$redHex = this.getRedHex();
        String other$redHex = other.getRedHex();
        if (this$redHex == null ? other$redHex != null : !this$redHex.equals(other$redHex)) {
            return false;
        }
        String this$greenHex = this.getGreenHex();
        String other$greenHex = other.getGreenHex();
        if (this$greenHex == null ? other$greenHex != null : !this$greenHex.equals(other$greenHex)) {
            return false;
        }
        String this$blueHex = this.getBlueHex();
        String other$blueHex = other.getBlueHex();
        if (this$blueHex == null ? other$blueHex != null : !this$blueHex.equals(other$blueHex)) {
            return false;
        }
        String this$alphaHex = this.getAlphaHex();
        String other$alphaHex = other.getAlphaHex();
        if (this$alphaHex == null ? other$alphaHex != null : !this$alphaHex.equals(other$alphaHex)) {
            return false;
        }
        String this$alphaRatio = this.getAlphaRatio();
        String other$alphaRatio = other.getAlphaRatio();
        if (this$alphaRatio == null ? other$alphaRatio != null : !this$alphaRatio.equals(other$alphaRatio)) {
            return false;
        }
        String this$rgbColor = this.getRgbColor();
        String other$rgbColor = other.getRgbColor();
        if (this$rgbColor == null ? other$rgbColor != null : !this$rgbColor.equals(other$rgbColor)) {
            return false;
        }
        String this$rgbaColor = this.getRgbaColor();
        String other$rgbaColor = other.getRgbaColor();
        if (this$rgbaColor == null ? other$rgbaColor != null : !this$rgbaColor.equals(other$rgbaColor)) {
            return false;
        }
        String this$hexColor = this.getHexColor();
        String other$hexColor = other.getHexColor();
        if (this$hexColor == null ? other$hexColor != null : !this$hexColor.equals(other$hexColor)) {
            return false;
        }
        String this$hexColorAlpha = this.getHexColorAlpha();
        String other$hexColorAlpha = other.getHexColorAlpha();
        return !(this$hexColorAlpha == null ? other$hexColorAlpha != null : !this$hexColorAlpha.equals(other$hexColorAlpha));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ColorVo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getRed();
        result = result * 59 + this.getGreen();
        result = result * 59 + this.getBlue();
        result = result * 59 + this.getAlpha();
        Integer $decimalColor = this.getDecimalColor();
        result = result * 59 + ($decimalColor == null ? 43 : ((Object)$decimalColor).hashCode());
        String $redHex = this.getRedHex();
        result = result * 59 + ($redHex == null ? 43 : $redHex.hashCode());
        String $greenHex = this.getGreenHex();
        result = result * 59 + ($greenHex == null ? 43 : $greenHex.hashCode());
        String $blueHex = this.getBlueHex();
        result = result * 59 + ($blueHex == null ? 43 : $blueHex.hashCode());
        String $alphaHex = this.getAlphaHex();
        result = result * 59 + ($alphaHex == null ? 43 : $alphaHex.hashCode());
        String $alphaRatio = this.getAlphaRatio();
        result = result * 59 + ($alphaRatio == null ? 43 : $alphaRatio.hashCode());
        String $rgbColor = this.getRgbColor();
        result = result * 59 + ($rgbColor == null ? 43 : $rgbColor.hashCode());
        String $rgbaColor = this.getRgbaColor();
        result = result * 59 + ($rgbaColor == null ? 43 : $rgbaColor.hashCode());
        String $hexColor = this.getHexColor();
        result = result * 59 + ($hexColor == null ? 43 : $hexColor.hashCode());
        String $hexColorAlpha = this.getHexColorAlpha();
        result = result * 59 + ($hexColorAlpha == null ? 43 : $hexColorAlpha.hashCode());
        return result;
    }

    public String toString() {
        return "ColorVo(red=" + this.getRed() + ", green=" + this.getGreen() + ", blue=" + this.getBlue() + ", alpha=" + this.getAlpha() + ", redHex=" + this.getRedHex() + ", greenHex=" + this.getGreenHex() + ", blueHex=" + this.getBlueHex() + ", alphaHex=" + this.getAlphaHex() + ", alphaRatio=" + this.getAlphaRatio() + ", rgbColor=" + this.getRgbColor() + ", rgbaColor=" + this.getRgbaColor() + ", decimalColor=" + this.getDecimalColor() + ", hexColor=" + this.getHexColor() + ", hexColorAlpha=" + this.getHexColorAlpha() + ")";
    }
}

