/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.commons;

import cn.acyou.leo.framework.commons.ThreadAsyncCall;
import cn.acyou.leo.framework.model.Result;
import cn.acyou.leo.framework.util.SpringHelper;
import java.util.Date;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.web.context.request.async.DeferredResult;

public class AsyncManager {
    private static final Logger log = LoggerFactory.getLogger(AsyncManager.class);
    private static final ThreadPoolTaskExecutor taskExecutor = (ThreadPoolTaskExecutor)SpringHelper.getBean("threadPoolTaskExecutor");
    private static final ThreadPoolTaskScheduler scheduledExecutor = (ThreadPoolTaskScheduler)SpringHelper.getBean("scheduledExecutorService");

    private AsyncManager() {
    }

    public static ThreadPoolTaskExecutor executor() {
        return taskExecutor;
    }

    public static ThreadPoolTaskScheduler scheduleExecutor() {
        return scheduledExecutor;
    }

    public static void execute(Runnable task) {
        taskExecutor.execute(task);
    }

    public static Future<?> submit(Runnable task) {
        return taskExecutor.submit(task);
    }

    public static <T> Future<T> submit(Callable<T> task) {
        return taskExecutor.submit(task);
    }

    public static void schedule(Runnable task) {
        AsyncManager.schedule(task, 5L, TimeUnit.SECONDS);
    }

    public static void schedule(Runnable task, long delay, TimeUnit unit) {
        scheduledExecutor.schedule(task, new Date(unit.toMillis(delay) + System.currentTimeMillis()));
    }

    public static void scheduleAtFixedRate(Runnable task, Date startTime, long period, TimeUnit unit) {
        scheduledExecutor.scheduleAtFixedRate(task, startTime, period);
    }

    public static void scheduleWithFixedDelay(Runnable task, Date startTime, long delay) {
        scheduledExecutor.scheduleWithFixedDelay(task, startTime, delay);
    }

    public static <T> DeferredResult<Result<T>> newDeferredResult(Long timeoutValue) {
        DeferredResult deferredResult = new DeferredResult(timeoutValue);
        deferredResult.onTimeout(() -> deferredResult.setResult((Object)Result.error((String)"\u8bf7\u6c42\u8d85\u65f6")));
        deferredResult.onError(k -> deferredResult.setResult((Object)Result.error((String)"\u8bf7\u6c42\u51fa\u9519")));
        return deferredResult;
    }

    public static void deferredRun(Supplier<Object> supplier) {
        ThreadAsyncCall.run(supplier);
    }

    public static void deferredRun(long interval, Supplier<Object> supplier) {
        ThreadAsyncCall.run(interval, supplier);
    }

    public static void shutdown() {
        taskExecutor.shutdown();
        scheduledExecutor.shutdown();
    }
}

