/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.commons;

import cn.acyou.leo.framework.base.EnumEntity;
import cn.acyou.leo.framework.util.ReflectUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnumTool {
    private static final Logger log = LoggerFactory.getLogger(EnumTool.class);
    protected Class<?> clazz;

    public static EnumTool newInstance(Class<?> clazz) {
        return new EnumTool(clazz);
    }

    private EnumTool(Class<?> clazz) {
        this.clazz = clazz;
    }

    public List<EnumEntity> listAllField() {
        ArrayList<EnumEntity> resultList = new ArrayList<EnumEntity>();
        List<Field> fields = ReflectUtils.getFields(this.clazz);
        try {
            for (Field field : fields) {
                field.setAccessible(true);
                Object o = field.get(this.clazz);
                if (o instanceof EnumEntity) {
                    resultList.add((EnumEntity)o);
                }
                field.setAccessible(false);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return resultList;
    }

    public String getFieldName(String code) {
        List<EnumEntity> statusEntities = this.listAllField();
        for (EnumEntity statusEntity : statusEntities) {
            if (!code.equals(statusEntity.getCode())) continue;
            return statusEntity.getName();
        }
        return null;
    }

    public String getFieldName(Integer code) {
        return this.getFieldName(code.toString());
    }
}

