/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.commons;

import cn.acyou.leo.framework.base.ColorVo;
import cn.acyou.leo.framework.constant.CommonErrorEnum;
import cn.acyou.leo.framework.context.AppContext;
import cn.acyou.leo.framework.exception.ServiceException;
import cn.acyou.leo.framework.model.ErrorEnum;
import cn.acyou.leo.framework.model.Result;
import cn.acyou.leo.framework.util.AvatarHelper;
import cn.acyou.leo.framework.util.IPUtil;
import cn.acyou.leo.framework.util.IdUtil;
import cn.acyou.leo.framework.util.RSAUtils;
import cn.acyou.leo.framework.util.RandomUtil;
import cn.acyou.leo.framework.util.WorkUtil;
import cn.acyou.leo.framework.util.component.TencentMapUtil;
import cn.acyou.leo.framework.util.redis.RedisUtils;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import cn.hutool.http.Method;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/sys/common"})
@Api(tags={"\u7cfb\u7edf\u516c\u5171\u4f7f\u7528"}, hidden=true)
public class SysCommonController {
    private static final Logger log = LoggerFactory.getLogger(SysCommonController.class);
    @Autowired(required=false)
    private RedisUtils redisUtils;
    @Autowired(required=false)
    private TencentMapUtil tencentMapUtil;

    @GetMapping(value={"/status"})
    @ApiOperation(value="\u72b6\u6001\u68c0\u67e5")
    @ResponseBody
    public String check() {
        return "ok";
    }

    @GetMapping(value={"/unauthorized"})
    @ApiOperation(value="\u6ca1\u6709\u6743\u9650")
    @ResponseBody
    public Result<Void> unauthorized() {
        return Result.error((ErrorEnum)CommonErrorEnum.E_UNAUTHORIZED);
    }

    @ApiOperation(value="\u6253\u5370\u8bf7\u6c42\u4fe1\u606f")
    @RequestMapping(value={"print"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public Result<JSONObject> printRequest(HttpServletRequest request, @RequestBody(required=false) Object requestBody, @RequestHeader Map<String, Object> requestHeader) {
        Map requestParameter = request.getParameterMap();
        JSONObject response = new JSONObject();
        response.put("requestParameter", (Object)requestParameter);
        response.put("requestBody", requestBody);
        response.put("requestHeader", requestHeader);
        return Result.success((Object)response);
    }

    @ApiOperation(value="\u83b7\u53d6\u670d\u52a1\u5668\u5916\u7f51IP")
    @GetMapping(value={"ip"})
    @ResponseBody
    public Result<JSONObject> ip() {
        String s = HttpUtil.get((String)"http://httpbin.org/ip");
        log.info("\u670d\u52a1\u5668\u5916\u7f51IP\uff1a{}", (Object)s);
        JSONObject jsonObject = JSON.parseObject((String)s);
        jsonObject.put("local", (Object)IPUtil.getLocalIP());
        jsonObject.put("client", (Object)AppContext.getIp());
        return Result.success((Object)jsonObject);
    }

    @ApiOperation(value="\u83b7\u53d6IP\u5c5e\u5730")
    @GetMapping(value={"ipAddr"})
    @ResponseBody
    public Result<JSONObject> ipAddr(String ip) {
        if (this.tencentMapUtil == null) {
            throw new ServiceException("please create key at [https://lbs.qq.com/service/webService/webServiceGuide/webServiceIp]");
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)ip)) {
            String s = HttpUtil.get((String)"http://httpbin.org/ip");
            ip = JSON.parseObject((String)s).getString("origin");
        }
        JSONObject ipLocation = this.tencentMapUtil.getIpLocation(ip);
        return Result.success((Object)ipLocation);
    }

    @ApiOperation(value="\u83b7\u53d6IP\u5c5e\u5730V2")
    @GetMapping(value={"ipAddrV2"})
    @ResponseBody
    public Result<JSONObject> ipAddrV2(String ip) {
        return WorkUtil.doRetryWork(3, () -> {
            JSONObject res = new JSONObject(true);
            String s = org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)ip) ? HttpUtil.get((String)("https://qifu.baidu.com/ip/geo/v1/district?ip=" + ip)) : HttpUtil.get((String)"https://qifu.baidu.com/ip/local/geo/v1/district");
            JSONObject ipLocation = JSON.parseObject((String)s);
            res.put("ip", (Object)ip);
            res.put("continent", (Object)ipLocation.getJSONObject("data").getString("continent"));
            res.put("country", (Object)ipLocation.getJSONObject("data").getString("country"));
            res.put("prov", (Object)ipLocation.getJSONObject("data").getString("prov"));
            res.put("city", (Object)ipLocation.getJSONObject("data").getString("city"));
            res.put("district", (Object)ipLocation.getJSONObject("data").getString("district"));
            res.put("owner", (Object)ipLocation.getJSONObject("data").getString("owner"));
            res.put("zipcode", (Object)ipLocation.getJSONObject("data").getString("zipcode"));
            res.put("lat", (Object)ipLocation.getJSONObject("data").getString("lat"));
            res.put("lng", (Object)ipLocation.getJSONObject("data").getString("lng"));
            return Result.success((Object)res);
        });
    }

    @GetMapping(value={"/color"})
    @ApiOperation(value="\u83b7\u53d6\u968f\u673a\u989c\u8272")
    @ResponseBody
    public Result<List<ColorVo>> color(@RequestParam(value="count", defaultValue="1") Integer count, Boolean hasAlpla) {
        ArrayList<ColorVo> res = new ArrayList<ColorVo>();
        for (int i = 0; i < count; ++i) {
            res.add(RandomUtil.randomColor(hasAlpla));
        }
        return Result.success(res);
    }

    @GetMapping(value={"/hashAvatar"})
    @ApiOperation(value="Hash\u5934\u50cf\u751f\u6210")
    public void hashAvatar(@RequestParam(value="num", required=false) Integer num, HttpServletResponse response) throws Exception {
        response.setContentType("image/gif");
        response.setHeader("Pragma", "No-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        ServletOutputStream os = response.getOutputStream();
        AvatarHelper.create(num != null ? num : RandomUtil.createRandomInt(), (OutputStream)os);
    }

    @GetMapping(value={"/rsa"})
    @ApiOperation(value="\u83b7\u53d6\u516c\u94a5")
    @ResponseBody
    public Result<String> rsa() throws Exception {
        String token = AppContext.getToken();
        Map<Integer, String> key = RSAUtils.genKeyPair();
        this.redisUtils.set("USER_RSA:" + token, JSON.toJSONString(key), 1L, TimeUnit.DAYS);
        return Result.success((Object)key.get(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GetMapping(value={"/idempotent"})
    @ApiOperation(value="\u83b7\u53d6\u5e42\u7b49\u5e8f\u5217 prefix\u524d\u7f00\uff08\u5fc5\u4f20\uff09\u3002sequence\uff1a\u7a7a\u65f6\u751f\u6210\uff0c\u975e\u7a7a\u65f6\u5224\u65ad\u3002operate\uff1a\u6821\u9a8c\u5e76\u5220\u9664")
    @ResponseBody
    public Result<String> idempotent(@RequestParam(value="prefix") String prefix, String sequence, String operate) {
        if (sequence == null || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)sequence)) {
            String uuid = IdUtil.uuidStrWithoutLine();
            this.redisUtils.set("LEO:AUTO_IDEMPOTENT_SEQUENCE:" + prefix + uuid, "1", 1L, TimeUnit.HOURS);
            return Result.success((Object)uuid);
        }
        String key = "LEO:AUTO_IDEMPOTENT_SEQUENCE:" + prefix + sequence;
        String v = null;
        try {
            v = this.redisUtils.get(key);
            if (!StringUtils.hasText((String)v)) {
                throw new ServiceException(CommonErrorEnum.REPETITIVE_OPERATION);
            }
            Result result = Result.success((Object)sequence);
            return result;
        }
        finally {
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)operate) && "delete".equalsIgnoreCase(operate)) {
                this.redisUtils.delete(key);
            }
        }
    }

    @PostMapping(value={"curl_request"})
    @ApiOperation(value="\u63a5\u53e3\u6d4b\u8bd5\u8bf7\u6c42")
    @ResponseBody
    public Result<?> curlRequest(@RequestBody(required=false) JSONObject param) {
        log.info("\u63a5\u53e3\u6d4b\u8bd5\u8bf7\u6c42 {}", (Object)param);
        String httpType = param.getString("httpType");
        String httpHost = param.getString("httpHost");
        JSONArray httpHeaders = param.getJSONArray("httpHeaders");
        String httpBody = param.getString("httpBody");
        HttpRequest request = HttpUtil.createRequest((Method)Method.valueOf((String)httpType), (String)httpHost);
        request.setFollowRedirects(false);
        request.setConnectionTimeout(60000);
        if (httpHeaders != null) {
            for (int i = 0; i < httpHeaders.size(); ++i) {
                JSONObject headerItem = httpHeaders.getJSONObject(i);
                String key = headerItem.getString("key");
                String value = headerItem.getString("value");
                if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)key)) continue;
                request.header(key, value);
            }
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)httpBody)) {
            request.body(httpBody);
        }
        HttpResponse response = request.execute();
        LinkedHashMap<String, Object> res = new LinkedHashMap<String, Object>();
        LinkedHashMap requestHeadersMap = new LinkedHashMap();
        LinkedHashMap responseHeadersMap = new LinkedHashMap();
        request.headers().forEach((k, v) -> {
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)k)) {
                requestHeadersMap.put(k, v.get(0));
            }
        });
        response.headers().forEach((k, v) -> {
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)k)) {
                responseHeadersMap.put(k, v.get(0));
            }
        });
        res.put("requestHeaders", requestHeadersMap);
        res.put("responseHeaders", responseHeadersMap);
        res.put("responseBody", "");
        if (response.header("Content-Type").contains("json")) {
            res.put("responseBody", response.body());
        }
        return Result.success(res);
    }

    @GetMapping(value={"/error"})
    @ApiOperation(value="MV\u9519\u8bef\u9875\u9762")
    @ResponseBody
    public Result<?> error(HttpServletRequest request) {
        int status = (Integer)request.getAttribute("status");
        String error = (String)request.getAttribute("error");
        String message = (String)request.getAttribute("message");
        Result resultError = Result.error((int)status, (String)(error + "|" + message));
        if (HttpStatus.NOT_FOUND.value() == status) {
            resultError = Result.error((ErrorEnum)CommonErrorEnum.E_NOT_FOUNT);
        }
        return resultError;
    }
}

