/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.commons;

import java.util.Map;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class ThreadAsyncCall {
    private static final Logger log = LoggerFactory.getLogger(ThreadAsyncCall.class);
    private static final DelayQueue<DelayTask> QUEUE = new DelayQueue();

    public static void run(Supplier<Object> supplier) {
        ThreadAsyncCall.run(2000L, supplier);
    }

    public static void run(long interval, Supplier<Object> supplier) {
        Map contextMap = MDC.getCopyOfContextMap();
        DelayTask delayTask = new DelayTask(interval, supplier, contextMap, interval, TimeUnit.MILLISECONDS);
        QUEUE.add(delayTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private static /* synthetic */ void lambda$static$0() {
        try {
            while (true) lbl-1000:
            // 7 sources

            {
                if (ThreadAsyncCall.QUEUE.size() != 0) {
                    task = (DelayTask)ThreadAsyncCall.QUEUE.poll(10L, TimeUnit.MINUTES);
                    try {
                        if (task == null) ** GOTO lbl-1000
                        contextMap = task.getContextMap();
                        MDC.setContextMap(contextMap);
                        supplier = task.getSupplier();
                        res = supplier.get();
                        if (res != null) ** GOTO lbl-1000
                        ThreadAsyncCall.run(task.getSleep(), task.getSupplier());
                    }
                    catch (Throwable e) {
                        ThreadAsyncCall.log.error("thread async call function run error.");
                        e.printStackTrace();
                    }
                    finally {
                        MDC.clear();
                    }
                    continue;
                }
                Thread.sleep(500L);
            }
        }
        catch (Throwable e) {
            ThreadAsyncCall.log.error("thread async call system error.");
            e.printStackTrace();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Class<ThreadAsyncCall> clazz = ThreadAsyncCall.class;
        synchronized (ThreadAsyncCall.class) {
            log.info("thread async call \u521d\u59cb\u5316");
            Thread thread = new Thread(ThreadAsyncCall::lambda$static$0);
            thread.setDaemon(true);
            thread.setName("ThreadAsyncCall");
            thread.start();
            log.info("thread async call \u521d\u59cb\u5316\u5b8c\u6210");
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    static class DelayTask
    implements Delayed {
        private final long time;
        private long sleep;
        private Map<String, String> contextMap;
        private Supplier<Object> supplier;

        public DelayTask(long sleep, Supplier<Object> supplier, Map<String, String> contextMap, long time, TimeUnit unit) {
            this.sleep = sleep;
            this.supplier = supplier;
            this.contextMap = contextMap;
            this.time = System.currentTimeMillis() + (time > 0L ? unit.toMillis(time) : 0L);
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return this.time - System.currentTimeMillis();
        }

        @Override
        public int compareTo(Delayed o) {
            DelayTask Order2 = (DelayTask)o;
            long diff = this.time - Order2.time;
            if (diff <= 0L) {
                return -1;
            }
            return 1;
        }

        public long getTime() {
            return this.time;
        }

        public long getSleep() {
            return this.sleep;
        }

        public Map<String, String> getContextMap() {
            return this.contextMap;
        }

        public Supplier<Object> getSupplier() {
            return this.supplier;
        }

        public void setSleep(long sleep) {
            this.sleep = sleep;
        }

        public void setContextMap(Map<String, String> contextMap) {
            this.contextMap = contextMap;
        }

        public void setSupplier(Supplier<Object> supplier) {
            this.supplier = supplier;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DelayTask)) {
                return false;
            }
            DelayTask other = (DelayTask)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getTime() != other.getTime()) {
                return false;
            }
            if (this.getSleep() != other.getSleep()) {
                return false;
            }
            Map<String, String> this$contextMap = this.getContextMap();
            Map<String, String> other$contextMap = other.getContextMap();
            if (this$contextMap == null ? other$contextMap != null : !((Object)this$contextMap).equals(other$contextMap)) {
                return false;
            }
            Supplier<Object> this$supplier = this.getSupplier();
            Supplier<Object> other$supplier = other.getSupplier();
            return !(this$supplier == null ? other$supplier != null : !this$supplier.equals(other$supplier));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DelayTask;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $time = this.getTime();
            result = result * 59 + (int)($time >>> 32 ^ $time);
            long $sleep = this.getSleep();
            result = result * 59 + (int)($sleep >>> 32 ^ $sleep);
            Map<String, String> $contextMap = this.getContextMap();
            result = result * 59 + ($contextMap == null ? 43 : ((Object)$contextMap).hashCode());
            Supplier<Object> $supplier = this.getSupplier();
            result = result * 59 + ($supplier == null ? 43 : $supplier.hashCode());
            return result;
        }

        public String toString() {
            return "ThreadAsyncCall.DelayTask(time=" + this.getTime() + ", sleep=" + this.getSleep() + ", contextMap=" + this.getContextMap() + ", supplier=" + this.getSupplier() + ")";
        }

        public DelayTask(long time, long sleep, Map<String, String> contextMap, Supplier<Object> supplier) {
            this.time = time;
            this.sleep = sleep;
            this.contextMap = contextMap;
            this.supplier = supplier;
        }
    }
}

