/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.config;

import cn.acyou.leo.framework.util.StringUtils;
import java.io.File;
import java.net.URL;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.boot.logging.DeferredLogFactory;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.FileUrlResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;

public class ExtendEnvironmentPostProcessor
implements EnvironmentPostProcessor {
    private final Log log;

    public ExtendEnvironmentPostProcessor(DeferredLogFactory logFactory) {
        this.log = logFactory.getLog(ExtendEnvironmentPostProcessor.class);
    }

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        MutablePropertySources propertySources = environment.getPropertySources();
        try {
            File[] files;
            File extendPropertiesDir;
            ClassPathResource extendProperties = new ClassPathResource("extendProperties");
            if (extendProperties.exists() && (extendPropertiesDir = extendProperties.getFile()).exists() && (files = extendPropertiesDir.listFiles()) != null && files.length > 0) {
                File[] fileArray = files;
                int n = fileArray.length;
                for (int i = 0; i < n; ++i) {
                    File listFile = fileArray[i];
                    Properties properties = PropertiesLoaderUtils.loadProperties((Resource)new ClassPathResource("extendProperties" + File.separator + listFile.getName()));
                    propertySources.addFirst((PropertySource)new PropertiesPropertySource("extendConfig_" + listFile.getName(), properties));
                    Properties propertiesSys = System.getProperties();
                    propertiesSys.load(new ClassPathResource("extendProperties" + File.separator + listFile.getName()).getInputStream());
                    System.setProperties(propertiesSys);
                    this.log.info((Object)("\u6269\u5c55\u914d\u7f6e \u52a0\u8f7d\u6210\u529f\uff01 \u8def\u5f84\uff1a[" + listFile.getPath() + "]"));
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)("\u6269\u5c55\u914d\u7f6e \u52a0\u8f7d\u5931\u8d25\uff01 \u539f\u56e0\uff1a" + e.getClass().getName() + "[" + e.getMessage() + "]"));
        }
        String propertyPaths = environment.getProperty("leo.extend-properties-paths");
        if (StringUtils.isNotBlank((CharSequence)propertyPaths)) {
            String[] split;
            for (String propertyPath : split = propertyPaths.split(",")) {
                try {
                    Properties properties;
                    Properties propertiesSys = System.getProperties();
                    if (propertyPath.startsWith("http")) {
                        properties = PropertiesLoaderUtils.loadProperties((Resource)new FileUrlResource(new URL(propertyPath)));
                        propertiesSys.load(new FileUrlResource(new URL(propertyPath)).getInputStream());
                    } else {
                        properties = PropertiesLoaderUtils.loadProperties((Resource)new FileSystemResource(propertyPath));
                        propertiesSys.load(new FileSystemResource(propertyPath).getInputStream());
                    }
                    propertySources.addFirst((PropertySource)new PropertiesPropertySource("extendConfig", properties));
                    System.setProperties(propertiesSys);
                    this.log.info((Object)("\u6269\u5c55\u914d\u7f6e \u52a0\u8f7d\u6210\u529f\uff01 \u8def\u5f84\uff1a[" + propertyPath + "]"));
                }
                catch (Exception e) {
                    this.log.error((Object)("\u6269\u5c55\u914d\u7f6e \u52a0\u8f7d\u5931\u8d25\uff01 \u539f\u56e0\uff1a" + e.getClass().getName() + "[" + e.getMessage() + "]"));
                }
            }
        }
    }
}

