/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.config;

import cn.acyou.leo.framework.annotation.valid.DictValue;
import cn.acyou.leo.framework.annotation.valid.ListValue;
import cn.acyou.leo.framework.annotation.valid.PropertyScriptAssert;
import cn.acyou.leo.framework.constraintvalidators.DictValueConstraintValidator;
import cn.acyou.leo.framework.constraintvalidators.ListValueConstraintValidator;
import cn.acyou.leo.framework.constraintvalidators.PropertyScriptAssertValidator;
import cn.acyou.leo.framework.mybatis.PerformanceInterceptor;
import cn.acyou.leo.framework.mybatis.extend.CustomerSqlInjector;
import com.baomidou.mybatisplus.core.injector.ISqlInjector;
import javax.validation.Validation;
import javax.validation.Validator;
import org.hibernate.validator.HibernateValidator;
import org.hibernate.validator.HibernateValidatorConfiguration;
import org.hibernate.validator.cfg.ConstraintMapping;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.retry.annotation.EnableRetry;
import org.springframework.scheduling.annotation.EnableScheduling;

@EnableRetry
@EnableScheduling
@Configuration
public class FrameworkBeanConfig {
    @Bean
    public Validator getValidator() {
        HibernateValidatorConfiguration configuration = (HibernateValidatorConfiguration)Validation.byProvider(HibernateValidator.class).configure();
        ConstraintMapping constraintMapping = configuration.createConstraintMapping();
        constraintMapping.constraintDefinition(ListValue.class).includeExistingValidators(false).validatedBy(ListValueConstraintValidator.class);
        constraintMapping.constraintDefinition(DictValue.class).includeExistingValidators(false).validatedBy(DictValueConstraintValidator.class);
        constraintMapping.constraintDefinition(PropertyScriptAssert.class).includeExistingValidators(false).validatedBy(PropertyScriptAssertValidator.class);
        configuration.failFast(true);
        return ((HibernateValidatorConfiguration)configuration.addMapping(constraintMapping)).buildValidatorFactory().getValidator();
    }

    @Bean
    public ISqlInjector iSqlInjector() {
        return new CustomerSqlInjector();
    }

    @Bean(value={"performanceInterceptor"})
    @ConditionalOnProperty(value={"leo.debug.print-performance-sql"}, havingValue="true")
    public PerformanceInterceptor performanceInterceptor() {
        return new PerformanceInterceptor();
    }
}

