/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.config;

import cn.acyou.leo.framework.aspect.ApiDocSecurityFilter;
import cn.acyou.leo.framework.prop.ApiDocProperty;
import com.github.xiaoymin.knife4j.spring.extension.OpenApiExtensionResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.Contact;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2WebMvc;

@Configuration
@EnableSwagger2WebMvc
@EnableConfigurationProperties(value={ApiDocProperty.class})
public class Knife4jEnhanceConfig {
    private static final Logger log = LoggerFactory.getLogger(Knife4jEnhanceConfig.class);
    private static final String GROUP_NAME = "1.0";
    private OpenApiExtensionResolver openApiExtensionResolver;
    @Autowired
    private ApiDocProperty apiDocProperty;

    @Autowired(required=false)
    public void setEnhanceConfig(OpenApiExtensionResolver openApiExtensionResolver) {
        if (openApiExtensionResolver != null) {
            this.openApiExtensionResolver = openApiExtensionResolver;
            String tipMessage = "";
            if (!this.apiDocProperty.getEnable().booleanValue()) {
                tipMessage = "\u6ce8\u610f\uff1a\u57fa\u7840\u6a21\u5f0f\u672a\u542f\u7528\uff0c\u8bf7\u5148\u542f\u7528\u3002";
            }
            log.info("[\u5f00\u53d1\u6587\u6863] \u914d\u7f6e\u589e\u5f3a\u6a21\u5f0f\uff01" + tipMessage);
        }
    }

    @Bean(value={"defaultApi2"})
    @ConditionalOnProperty(value={"leo.api.enable"}, havingValue="true")
    public Docket defaultApi2() {
        Docket docket = new Docket(DocumentationType.SWAGGER_2).apiInfo(new ApiInfoBuilder().title(this.apiDocProperty.getTitle()).description(this.apiDocProperty.getDescription()).termsOfServiceUrl(this.apiDocProperty.getTermsOfServiceUrl()).contact(new Contact(this.apiDocProperty.getContact(), "", "")).version(this.apiDocProperty.getVersion()).build()).groupName(GROUP_NAME).select().apis(RequestHandlerSelectors.basePackage((String)this.apiDocProperty.getBasePackage())).paths(PathSelectors.any()).build();
        if (this.openApiExtensionResolver != null) {
            docket.extensions(this.openApiExtensionResolver.buildExtensions(GROUP_NAME));
        }
        log.info("[\u5f00\u53d1\u6587\u6863] \u521d\u59cb\u5316\u5b8c\u6210\uff01");
        return docket;
    }

    @Bean(value={"myProductionSecurityFilter"})
    @ConditionalOnProperty(value={"leo.api.enable"}, havingValue="false")
    public ApiDocSecurityFilter productionSecurityFilter() {
        return new ApiDocSecurityFilter();
    }
}

