/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.config;

import cn.acyou.leo.framework.config.ThreadPoolConfig;
import cn.acyou.leo.framework.util.WorkUtil;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.interceptor.AsyncUncaughtExceptionHandler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.scheduling.annotation.AsyncConfigurerSupport;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@EnableAsync
@AutoConfigureAfter(value={ThreadPoolConfig.class})
@ConditionalOnBean(name={"threadPoolTaskExecutor"})
public class ThreadAsyncConfig
extends AsyncConfigurerSupport {
    private static final Logger log = LoggerFactory.getLogger(ThreadAsyncConfig.class);
    @Autowired(required=false)
    @Qualifier(value="threadPoolTaskExecutor")
    private ThreadPoolTaskExecutor threadPoolExecutor;

    public Executor getAsyncExecutor() {
        return this.threadPoolExecutor;
    }

    public AsyncUncaughtExceptionHandler getAsyncUncaughtExceptionHandler() {
        return (arg0, arg1, arg2) -> {
            log.error("An error has occurred on async thread ========" + arg0.getMessage() + "========", arg0);
            WorkUtil.printFirstStack(arg0);
        };
    }
}

