/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.util;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Base64;
import java.util.Random;
import javax.imageio.ImageIO;

public class AvatarHelper {
    public static final String BASE64_PREFIX = "data:image/png;base64,";

    public static String createBase64Avatar(int id) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)AvatarHelper.createAvatar(id), "png", os);
        return new String(Base64.getEncoder().encode(os.toByteArray()));
    }

    public static void create(int id, OutputStream os) throws IOException {
        BufferedImage avatar = AvatarHelper.createAvatar(id);
        ImageIO.write((RenderedImage)avatar, "png", os);
    }

    public static BufferedImage createAvatar(int id) {
        int width = 40;
        int grid = 5;
        int padding = width / 2;
        int size = width * grid + width;
        BufferedImage img = new BufferedImage(size, size, 1);
        Graphics2D _2d = img.createGraphics();
        _2d.setColor(new Color(240, 240, 240));
        _2d.fillRect(0, 0, size, size);
        _2d.setColor(AvatarHelper.randomColor(80, 200));
        char[] idchars = AvatarHelper.createIdent(id);
        int i = idchars.length;
        int x = 0;
        while ((double)x < Math.ceil((double)grid / 2.0)) {
            for (int y = 0; y < grid; ++y) {
                if (idchars[--i] >= '5') continue;
                _2d.fillRect(padding + x * width, padding + y * width, width, width);
                if (!((double)x < Math.floor(grid / 2))) continue;
                _2d.fillRect(padding + (grid - 1 - x) * width, padding + y * width, width, width);
            }
            ++x;
        }
        _2d.dispose();
        return img;
    }

    private static Color randomColor(int fc, int bc) {
        Random random = new Random();
        if (fc > 255) {
            fc = 255;
        }
        if (bc > 255) {
            bc = 255;
        }
        int r = fc + random.nextInt(Math.abs(bc - fc));
        int g = fc + random.nextInt(Math.abs(bc - fc));
        int b = fc + random.nextInt(Math.abs(bc - fc));
        return new Color(r, g, b);
    }

    private static char[] createIdent(int id) {
        BigInteger bi_content = new BigInteger((id + "").getBytes());
        BigInteger bi = new BigInteger(id + "identicon" + id, 36);
        bi = bi.xor(bi_content);
        return bi.toString(10).toCharArray();
    }
}

