/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.util;

import cn.acyou.leo.framework.util.RegexUtil;
import cn.acyou.leo.framework.util.StringUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Days;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.Weeks;
import org.joda.time.format.DateTimeFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DateUtil {
    private static final Logger log = LoggerFactory.getLogger(DateUtil.class);
    public static final String FORMAT_SHORT_DATE = "yyyyMMdd";
    public static final String FORMAT_DEFAULT_DATE = "yyyy-MM-dd";
    public static final String FORMAT_DEFAULT_TIME = "HH:mm:ss";
    public static final String FORMAT_DATE_TIME = "yyyy-MM-dd HH:mm:ss";
    public static final String FORMAT_DATE_TIME_2 = "yyyy-M-d HH:mm:ss";
    public static final String FORMAT_DATE_TIME_UNSIGNED = "yyyyMMddHHmmss";
    public static final String DATE_DAY_MIN_TIME = " 00:00:00";
    public static final String DATE_DAY_MAX_TIME = " 23:59:59";
    public static final char[] UPPER_NUMBER = "\u3007\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d\u5341".toCharArray();
    public static final long ONE_HOUR_SECOND = 3600L;
    public static final int DAYS_PER_WEEKEND = 2;
    public static final int WEEK_START = 1;
    public static final int WEEK_END = 5;
    private static long prevUseTimeStamp = 0L;

    private DateUtil() {
    }

    public static String getDateFormat(Date date) {
        return DateUtil.getDateFormat(date, FORMAT_DATE_TIME);
    }

    public static String getCurrentDateFormat() {
        return DateUtil.getDateFormat(new Date(), FORMAT_DATE_TIME);
    }

    public static String getDateShortFormat(Date date) {
        return DateUtil.getDateFormat(date, FORMAT_SHORT_DATE);
    }

    public static String getDateDefaultFormat(Date date) {
        return DateUtil.getDateFormat(date, FORMAT_DEFAULT_DATE);
    }

    public static String getCurrentDateShortFormat() {
        return DateUtil.getDateFormat(new Date(), FORMAT_SHORT_DATE);
    }

    public static String getCurrentDateDefaultFormat() {
        return DateUtil.getDateFormat(new Date(), FORMAT_DEFAULT_DATE);
    }

    public static String getCurrentDateFormat(String format) {
        return DateUtil.getDateFormat(new Date(), format);
    }

    public static String getDateFormat(Date date, String format) {
        if (date == null) {
            return "";
        }
        return new DateTime((Object)date).toString(format);
    }

    public static Date parseDefaultDate(String dateStr) {
        return DateUtil.parseDate(dateStr, FORMAT_DEFAULT_DATE);
    }

    public static Date newDate(int year, int monthOfYear, int dayOfMonth, int hourOfDay, int minuteOfHour, int secondOfMinute) {
        return new DateTime(year, monthOfYear, dayOfMonth, hourOfDay, minuteOfHour, secondOfMinute).toDate();
    }

    public static Date newDate(int year, int monthOfYear, int dayOfMonth) {
        return new DateTime(year, monthOfYear, dayOfMonth, 0, 0, 0).toDate();
    }

    public static Date newDate(String dateStr) {
        if (!dateStr.contains(" ")) {
            return DateUtil.parseDate(dateStr, FORMAT_DEFAULT_DATE);
        }
        return DateUtil.parseSpecificDateTime(dateStr);
    }

    public static Date parseSpecificDateTime(String dateStr) {
        return DateUtil.parseDate(dateStr, FORMAT_DATE_TIME);
    }

    public static Date parseDate(String dateStr, String format) {
        return DateTimeFormat.forPattern((String)format).parseDateTime(dateStr).toDate();
    }

    public static Date add(Date date, int year, int month, int day, int hour, int minute, int second) {
        return new DateTime((Object)date).plusYears(year).plusMonths(month).plusDays(day).plusHours(hour).plusMillis(minute).plusSeconds(second).toDate();
    }

    public static Date minus(Date date, int year, int month, int day, int hour, int minute, int second) {
        return new DateTime((Object)date).minusYears(year).minusMonths(month).minusDays(day).minusHours(hour).minusMillis(minute).minusSeconds(second).toDate();
    }

    public static Date addDay(Date date, int day) {
        return new DateTime((Object)date).plusDays(day).toDate();
    }

    public static Date minusDay(Date date, int day) {
        return new DateTime((Object)date).minusDays(day).toDate();
    }

    public static Date addMonth(Date date, int month) {
        return new DateTime((Object)date).plusMonths(month).toDate();
    }

    public static Date addYear(Date date, int year) {
        return new DateTime((Object)date).plusYears(year).toDate();
    }

    public static Date minusMonth(Date date, int month) {
        return new DateTime((Object)date).minusMonths(month).toDate();
    }

    public static Date addHour(Date date, int hour) {
        return new DateTime((Object)date).plusHours(hour).toDate();
    }

    public static Date minusHour(Date date, int hour) {
        return new DateTime((Object)date).minusHours(hour).toDate();
    }

    public static Date addMinutes(Date date, int minutes) {
        return new DateTime((Object)date).plusMinutes(minutes).toDate();
    }

    public static Date minusMinutes(Date date, int minutes) {
        return new DateTime((Object)date).minusMinutes(minutes).toDate();
    }

    public static Date addSeconds(Date date, int seconds) {
        return new DateTime((Object)date).plusSeconds(seconds).toDate();
    }

    public static Date minusSeconds(Date date, int seconds) {
        return new DateTime((Object)date).minusSeconds(seconds).toDate();
    }

    public static Date randomRangeDate(String startStr, String endStr) {
        long startTime = new DateTime((Object)startStr).toDate().getTime();
        long endTime = new DateTime((Object)endStr).toDate().getTime();
        double randomDate = Math.random() * (double)(endTime - startTime) + (double)startTime;
        DateTime random = new DateTime(Math.round(randomDate));
        return random.toDate();
    }

    public static long getDiffSeconds(Date startDate, Date endDate) {
        return Math.abs((endDate.getTime() - startDate.getTime()) / 1000L);
    }

    public static long getDiffMinutes(Date startDate, Date endDate) {
        long diffSeconds = DateUtil.getDiffSeconds(startDate, endDate);
        return diffSeconds / 60L;
    }

    public static long getDiffHour(Date startDate, Date endDate) {
        long diffMinutes = DateUtil.getDiffMinutes(startDate, endDate);
        return diffMinutes / 60L;
    }

    public static BigDecimal getDiff(Date startDate, Date endDate, Unit unit) {
        long timeStart = startDate.getTime();
        long timeEnd = endDate.getTime();
        switch (unit) {
            case MILLISECOND: {
                return new BigDecimal(timeEnd - timeStart);
            }
            case SECOND: {
                return new BigDecimal(timeEnd - timeStart).divide(new BigDecimal(1000), 10, RoundingMode.FLOOR);
            }
            case MINUTE: {
                return new BigDecimal(timeEnd - timeStart).divide(new BigDecimal(1000), 10, RoundingMode.FLOOR).divide(new BigDecimal(60), 10, RoundingMode.FLOOR);
            }
            case HOUR: {
                return new BigDecimal(timeEnd - timeStart).divide(new BigDecimal(1000), 10, RoundingMode.FLOOR).divide(new BigDecimal(60), 10, RoundingMode.FLOOR).divide(new BigDecimal(60), 10, RoundingMode.FLOOR);
            }
            case DAY: {
                return new BigDecimal(timeEnd - timeStart).divide(new BigDecimal(1000), 10, RoundingMode.FLOOR).divide(new BigDecimal(60), 10, RoundingMode.FLOOR).divide(new BigDecimal(60), 10, RoundingMode.FLOOR).divide(new BigDecimal(24), 10, RoundingMode.FLOOR);
            }
            case MONTH: {
                return new BigDecimal(timeEnd - timeStart).divide(new BigDecimal(1000), 10, RoundingMode.FLOOR).divide(new BigDecimal(60), 10, RoundingMode.FLOOR).divide(new BigDecimal(60), 10, RoundingMode.FLOOR).divide(new BigDecimal(24), 10, RoundingMode.FLOOR).divide(new BigDecimal(30), 10, RoundingMode.FLOOR);
            }
            case YEAR: {
                return new BigDecimal(timeEnd - timeStart).divide(new BigDecimal(1000), 10, RoundingMode.FLOOR).divide(new BigDecimal(60), 10, RoundingMode.FLOOR).divide(new BigDecimal(60), 10, RoundingMode.FLOOR).divide(new BigDecimal(24), 10, RoundingMode.FLOOR).divide(new BigDecimal(30), 10, RoundingMode.FLOOR).divide(new BigDecimal(365), 10, RoundingMode.FLOOR);
            }
        }
        return new BigDecimal(0);
    }

    public static long getDiffDay(Date startDate, Date endDate) {
        long between = Math.abs((startDate.getTime() - endDate.getTime()) / 1000L);
        long day = between / 60L / 60L / 24L;
        if (startDate.after(endDate)) {
            return (long)(-Math.floor(day));
        }
        return (long)Math.floor(day);
    }

    public static long getCurrentDiffDay(Date startDate) {
        return DateUtil.getDiffDay(startDate, new Date());
    }

    public static long getCurrentDiffMinutes(Date startDate) {
        return DateUtil.getDiffMinutes(startDate, new Date());
    }

    public static int getDiffMonth(Date start, Date end) {
        Calendar startCalendar = Calendar.getInstance();
        startCalendar.setTime(start);
        Calendar endCalendar = Calendar.getInstance();
        endCalendar.setTime(end);
        return (endCalendar.get(1) - startCalendar.get(1)) * 12 + endCalendar.get(2) - startCalendar.get(2);
    }

    public static int getDiffYear(Date start, Date end) {
        Calendar startCalendar = Calendar.getInstance();
        startCalendar.setTime(start);
        Calendar endCalendar = Calendar.getInstance();
        endCalendar.setTime(end);
        return endCalendar.get(1) - startCalendar.get(1);
    }

    public static Date firstDayOfMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int value = cal.getActualMinimum(5);
        cal.set(5, value);
        return cal.getTime();
    }

    public static Date lastDayOfMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int value = cal.getActualMaximum(5);
        cal.set(5, value);
        return cal.getTime();
    }

    public static boolean isLeapYear(int year) {
        return year % 4 == 0 && year % 100 != 0 || year % 400 == 0;
    }

    public static int age(Date birthDay, Date dateToCompare) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(dateToCompare);
        if (cal.before(birthDay)) {
            throw new IllegalArgumentException("Birthday is after date " + DateUtil.getDateFormat(birthDay) + "!");
        }
        int year = cal.get(1);
        int month = cal.get(2);
        int dayOfMonth = cal.get(5);
        cal.setTime(birthDay);
        int age = year - cal.get(1);
        int monthBirth = cal.get(2);
        if (month == monthBirth) {
            int dayOfMonthBirth = cal.get(5);
            if (dayOfMonth < dayOfMonthBirth) {
                --age;
            }
        } else if (month < monthBirth) {
            --age;
        }
        return age;
    }

    public static Date randomDate() {
        return DateUtil.randomRangeDate("1990-01-01", "2018-12-31");
    }

    public static int workdayDiff(Date d1, Date d2) {
        LocalDate start = LocalDate.fromDateFields((Date)d1);
        LocalDate end = LocalDate.fromDateFields((Date)d2);
        start = DateUtil.toWorkday(start);
        end = DateUtil.toWorkday(end);
        int daysBetween = Days.daysBetween((ReadablePartial)start, (ReadablePartial)end).getDays();
        int weekendsBetween = Weeks.weeksBetween((ReadablePartial)start.withDayOfWeek(1), (ReadablePartial)end.withDayOfWeek(1)).getWeeks();
        return daysBetween - weekendsBetween * 2;
    }

    public static String getDateFormatMaxTime(Date date) {
        String dateFormat = DateUtil.getDateFormat(date, FORMAT_DEFAULT_DATE);
        return dateFormat + DATE_DAY_MAX_TIME;
    }

    public static String getDateFormatMinTime(Date date) {
        String dateFormat = DateUtil.getDateFormat(date, FORMAT_DEFAULT_DATE);
        return dateFormat + DATE_DAY_MIN_TIME;
    }

    public static String getUpperDate(Date date) {
        return DateUtil.getUpperDate(DateUtil.getDateShortFormat(date));
    }

    public static String getUpperDate() {
        return DateUtil.getUpperDate(new Date());
    }

    public static String getUpperDate(String date) {
        if (date == null) {
            return "";
        }
        if ((date = date.replaceAll("\\D", "")).length() != 8) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 4; ++i) {
            sb.append(UPPER_NUMBER[Integer.parseInt(date.substring(i, i + 1))]);
        }
        sb.append("\u5e74");
        int month = Integer.parseInt(date.substring(4, 6));
        if (month <= 10) {
            sb.append(UPPER_NUMBER[month]);
        } else {
            sb.append("\u5341").append(UPPER_NUMBER[month % 10]);
        }
        sb.append("\u6708");
        int day = Integer.parseInt(date.substring(6));
        if (day <= 10) {
            sb.append(UPPER_NUMBER[day]);
        } else if (day < 20) {
            sb.append("\u5341").append(UPPER_NUMBER[day % 10]);
        } else {
            sb.append(UPPER_NUMBER[day / 10]).append("\u5341");
            int tmp = day % 10;
            if (tmp != 0) {
                sb.append(UPPER_NUMBER[tmp]);
            }
        }
        sb.append("\u65e5");
        return sb.toString();
    }

    public static LocalDate toWorkday(LocalDate d) {
        if (d.getDayOfWeek() > 5) {
            return d.plusDays(7 - d.getDayOfWeek() + 1);
        }
        return d;
    }

    public static String getMonthEn(int month) {
        String[] allMonths = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
        if (0 < month && month < 13) {
            return allMonths[month - 1];
        }
        return "";
    }

    public static String getMonthZh(int month) {
        String[] allMonths = new String[]{"\u4e00\u6708", "\u4e8c\u6708", "\u4e09\u6708", "\u56db\u6708", "\u4e94\u6708", "\u516d\u6708", "\u4e03\u6708", "\u516b\u6708", "\u4e5d\u6708", "\u5341\u6708", "\u5341\u4e00\u6708", "\u5341\u4e8c\u6708"};
        if (0 < month && month < 13) {
            return allMonths[month - 1];
        }
        return "";
    }

    public static String weekdayZh(Date date) {
        DateTime dateTime = new DateTime((Object)date);
        return DateUtil.getWeekdayZh(dateTime.dayOfWeek().get());
    }

    public static String weekdayEn(Date date) {
        DateTime dateTime = new DateTime((Object)date);
        return DateUtil.getWeekdayEn(dateTime.dayOfWeek().get());
    }

    private static String getWeekdayZh(int week) {
        String[] allWeeks = new String[]{"\u661f\u671f\u4e00", "\u661f\u671f\u4e8c", "\u661f\u671f\u4e09", "\u661f\u671f\u56db", "\u661f\u671f\u4e94", "\u661f\u671f\u516d", "\u661f\u671f\u65e5"};
        if (0 < week && week < 13) {
            return allWeeks[week - 1];
        }
        return "";
    }

    private static String getWeekdayEn(int week) {
        String[] allWeeks = new String[]{"monday", "tuesday", "wednesday", "thursday", "friday", "saturday", "sunday"};
        if (0 < week && week < 13) {
            return allWeeks[week - 1];
        }
        return "";
    }

    public static String getMonthZh(String ymd) {
        int monthOfYear = DateTimeFormat.forPattern((String)FORMAT_DEFAULT_DATE).parseDateTime(ymd).getMonthOfYear();
        return DateUtil.getMonthZh(monthOfYear);
    }

    private static String getEnBirthDay(Date date) {
        DateTime dateTime = new DateTime((Object)date);
        String monthEn = DateUtil.getMonthEn(dateTime.getMonthOfYear());
        return monthEn + " " + dateTime.getDayOfMonth() + "." + dateTime.getYear();
    }

    public static boolean nowInRange(String dateStart, String dateEnd) {
        Date nowDate = new Date();
        Date startDate = DateUtil.parseSpecificDateTime(dateStart);
        Date endDate = DateUtil.parseSpecificDateTime(dateEnd);
        return nowDate.after(startDate) && nowDate.before(endDate);
    }

    public static boolean nowInTimeRange(String timeStart, String timeEnd) {
        if (RegexUtil.isTime(timeStart) && RegexUtil.isTime(timeEnd)) {
            Date nowDate = new Date();
            String dateFormat = DateUtil.getDateFormat(nowDate, FORMAT_DEFAULT_DATE);
            Date startDate = DateUtil.parseSpecificDateTime(dateFormat + " " + timeStart);
            Date endDate = DateUtil.parseSpecificDateTime(dateFormat + " " + timeEnd);
            return nowDate.after(startDate) && nowDate.before(endDate);
        }
        log.error("\u8ba1\u7b97\u73b0\u5728\u7684\u65f6\u95f4\u5728\u6307\u5b9a\u7684\u65f6\u95f4\u8303\u56f4\u5185\u9519\u8bef\uff01{}-{}", (Object)timeStart, (Object)timeEnd);
        return false;
    }

    public static Date getPreviousMonthFirstDayToDate() {
        return LocalDateTime.now().minusMonths(1).dayOfMonth().withMinimumValue().toDate();
    }

    public static Date getPreviousMonthLastDayToDate() {
        return LocalDateTime.now().minusMonths(1).dayOfMonth().withMaximumValue().toDate();
    }

    public static String getPreviousMonthFirstDayToString() {
        return new DateTime((Object)DateUtil.getPreviousMonthFirstDayToDate()).toString(FORMAT_DEFAULT_DATE);
    }

    public static String getPreviousMonthLastDayToString() {
        return new DateTime((Object)DateUtil.getPreviousMonthLastDayToDate()).toString(FORMAT_DEFAULT_DATE);
    }

    public static Date getCurrentMonthFirstDayToDate() {
        return LocalDateTime.now().dayOfMonth().withMinimumValue().toDate();
    }

    public static Date getCurrentMonthLastDayToDate() {
        return LocalDateTime.now().dayOfMonth().withMaximumValue().toDate();
    }

    public static String getCurrentMonthFirstDayToString() {
        return new DateTime((Object)DateUtil.getCurrentMonthFirstDayToDate()).toString(FORMAT_DEFAULT_DATE);
    }

    public static String getCurrentMonthLastDayToString() {
        return new DateTime((Object)DateUtil.getCurrentMonthLastDayToDate()).toString(FORMAT_DEFAULT_DATE);
    }

    public static Date getNextMonthFirstDayToDate() {
        return LocalDateTime.now().plusMonths(1).dayOfMonth().withMinimumValue().toDate();
    }

    public static Date getNextMonthLastDayToDate() {
        return LocalDateTime.now().plusMonths(1).dayOfMonth().withMaximumValue().toDate();
    }

    public static String getNextMonthFirstDayToString() {
        return new DateTime((Object)DateUtil.getNextMonthFirstDayToDate()).toString(FORMAT_DEFAULT_DATE);
    }

    public static String getNextMonthLastDayToString() {
        return new DateTime((Object)DateUtil.getNextMonthLastDayToDate()).toString(FORMAT_DEFAULT_DATE);
    }

    public static Date parseTime(Date date, String timeStr) {
        String dateFormat = DateUtil.getDateFormat(date, FORMAT_DEFAULT_DATE);
        return DateUtil.parseSpecificDateTime(dateFormat + " " + timeStr);
    }

    public static boolean afterTime(Date date, String timeStr) {
        Date when = DateUtil.parseTime(date, timeStr);
        return date.after(when);
    }

    public static boolean afterTodayTime(String timeStr) {
        Date date = new Date();
        Date when = DateUtil.parseTime(date, timeStr);
        return date.after(when);
    }

    public static boolean beforeTime(Date date, String timeStr) {
        Date when = DateUtil.parseTime(date, timeStr);
        return date.before(when);
    }

    public static boolean beforeTodayTime(String timeStr) {
        Date date = new Date();
        Date when = DateUtil.parseTime(date, timeStr);
        return date.before(when);
    }

    public static List<String> monthFirstDayInRange(String startDate, String endDate) {
        ArrayList<String> stringList = new ArrayList<String>();
        DateTime startDateTime = DateTimeFormat.forPattern((String)FORMAT_DEFAULT_DATE).parseDateTime(startDate).dayOfMonth().withMinimumValue();
        DateTime endDateTime = DateTimeFormat.forPattern((String)FORMAT_DEFAULT_DATE).parseDateTime(endDate).dayOfMonth().withMinimumValue();
        stringList.add(startDateTime.toString(FORMAT_DEFAULT_DATE));
        if (endDateTime.compareTo((ReadableInstant)startDateTime) < 0) {
            return stringList;
        }
        while (startDateTime.plusMonths(1).compareTo((ReadableInstant)endDateTime) < 0) {
            startDateTime = startDateTime.plusMonths(1);
            stringList.add(startDateTime.toString(FORMAT_DEFAULT_DATE));
        }
        return stringList;
    }

    public static String lastYearTodayMonth(String todayMonth) {
        return DateTimeFormat.forPattern((String)FORMAT_DEFAULT_DATE).parseDateTime(todayMonth).minusYears(1).dayOfMonth().withMinimumValue().toString(FORMAT_DEFAULT_DATE);
    }

    public static boolean isLegalTime(String pattern, String time) {
        try {
            DateTimeFormat.forPattern((String)pattern).parseDateTime(time);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isLegalTime(String time) {
        return DateUtil.isLegalTime(FORMAT_DEFAULT_TIME, time);
    }

    public static String extractDateStr(String sourceStr, DateRegex dateRegex) {
        Pattern pattern;
        Matcher matcher;
        if (StringUtils.isNotBlank((CharSequence)sourceStr) && (matcher = (pattern = dateRegex.getPattern()).matcher(sourceStr)).find()) {
            return matcher.group(0);
        }
        return "";
    }

    public static long getSerialTimeMillis() {
        return DateUtil.getSerialTimeMillis(1).get(0);
    }

    public static synchronized List<Long> getSerialTimeMillis(int count) {
        ArrayList<Long> resList = new ArrayList<Long>();
        long nowTime = System.currentTimeMillis();
        if (prevUseTimeStamp > 0L && nowTime < prevUseTimeStamp) {
            nowTime = prevUseTimeStamp;
        }
        for (int i = 0; i < count; ++i) {
            resList.add(nowTime);
            ++nowTime;
        }
        prevUseTimeStamp = nowTime;
        return resList;
    }

    public static Date max(Date ... dateArr) {
        Date maxDate = dateArr[0];
        for (Date date : dateArr) {
            if (!date.after(maxDate)) continue;
            maxDate = date;
        }
        return maxDate;
    }

    public static Date min(Date ... dateArr) {
        Date maxDate = dateArr[0];
        for (Date date : dateArr) {
            if (!date.before(maxDate)) continue;
            maxDate = date;
        }
        return maxDate;
    }

    public static Date parseUTC(String dateStr) {
        return DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ssZ").withZoneUTC().parseDateTime(dateStr).toDate();
    }

    public static String getDateUTC(Date date) {
        return new DateTime((Object)date).withZone(DateTimeZone.UTC).toString("yyyy-MM-dd'T'HH:mm:ssZ");
    }

    public static Date dayMaxDate(String dateStr) {
        return DateUtil.parseDate(DateUtil.dayMax(dateStr), FORMAT_DATE_TIME);
    }

    public static Date dayMinDate(String dateStr) {
        return DateUtil.parseDate(DateUtil.dayMin(dateStr), FORMAT_DATE_TIME);
    }

    public static String dayMax(String dateStr) {
        return dateStr + DATE_DAY_MAX_TIME;
    }

    public static String dayMin(String dateStr) {
        return dateStr + DATE_DAY_MIN_TIME;
    }

    public static void main(String[] args) {
        System.out.println(DateUtil.dayMin("2024-08-15"));
        System.out.println(DateUtil.dayMax("2024-08-15"));
        System.out.println(DateUtil.dayMinDate("2024-08-15"));
        System.out.println(DateUtil.dayMaxDate("2024-08-15"));
        System.out.println(DateUtil.nowInRange("2024-08-15 00:00:00", "2024-08-16 23:59:59"));
    }

    public static enum DateRegex {
        DateTime("[1-9]\\d{3}-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1]) (0[0-9]|1[0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])"),
        DateTime2("[1-9]\\d{3}-([1-9]|1[0-2])-([1-9]|[1-2][0-9]|3[0-1]) (0[0-9]|1[0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])"),
        Date("[1-9]\\d{3}-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])");

        private final Pattern pattern;

        private DateRegex(String patternStr) {
            this.pattern = Pattern.compile(patternStr);
        }

        public Pattern getPattern() {
            return this.pattern;
        }
    }

    public static enum Unit {
        YEAR,
        MONTH,
        DAY,
        HOUR,
        MINUTE,
        SECOND,
        MILLISECOND;

    }
}

