/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.util;

import cn.acyou.leo.framework.util.DateUtil;
import cn.acyou.leo.framework.util.FileUtil;
import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellBase;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.DefaultIndexedColorMap;
import org.apache.poi.xssf.usermodel.IndexedColorMap;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelUtil {
    private static final Logger log = LoggerFactory.getLogger(ExcelUtil.class);
    private static final DecimalFormat df = new DecimalFormat("0");
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyy-MM-dd");
    private static final DecimalFormat df2 = new DecimalFormat("0");

    public static List<Map<String, Object>> importData(String path) throws Exception {
        return ExcelUtil.importData(path, 0);
    }

    public static List<Map<String, Object>> importData(String path, int sheetIndex) throws Exception {
        XSSFWorkbook workbook = new XSSFWorkbook(new File(path));
        return ExcelUtil.importData(workbook.getSheetAt(sheetIndex));
    }

    public static List<Map<String, Object>> importData(XSSFSheet sheet) {
        return ExcelUtil.importData(sheet, 0);
    }

    public static List<Map<String, Object>> importData(XSSFSheet sheet, int headRow) {
        ArrayList<Map<String, Object>> ls = new ArrayList<Map<String, Object>>();
        XSSFRow heard = sheet.getRow(headRow);
        String[] title = new String[heard.getLastCellNum()];
        for (int y = heard.getFirstCellNum(); y < heard.getLastCellNum(); ++y) {
            title[y] = heard.getCell(y).getStringCellValue();
        }
        for (int j = headRow + 1; j < sheet.getLastRowNum() + 1; ++j) {
            XSSFRow row = sheet.getRow(j);
            LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
            for (int y = row.getFirstCellNum(); y < row.getLastCellNum(); ++y) {
                if (y >= title.length) continue;
                m.put(title[y], ExcelUtil.getCellValue((Cell)row.getCell(y)));
            }
            if (m.size() <= 0) continue;
            ls.add(m);
        }
        return ls;
    }

    public static void exportExcel(HttpServletResponse response, List<Map<String, Object>> dataList, String sheetName) throws IOException {
        ExcelUtil.setResponseExcel(response, sheetName);
        ExcelUtil.exportExcel((OutputStream)response.getOutputStream(), dataList, sheetName);
    }

    public static void setResponseExcel(HttpServletResponse response, String fileName) throws IOException {
        response.setContentType("application/vnd.ms-excel");
        response.setCharacterEncoding("utf-8");
        String headerStr = "attachment;filename=" + fileName + ".xlsx";
        response.setHeader("Content-Disposition", new String(headerStr.getBytes("GBK"), StandardCharsets.ISO_8859_1));
    }

    public static void exportExcel(OutputStream out, List<Map<String, Object>> dataList, String sheetName) throws IOException {
        LinkedHashMap<String, List<Map<String, Object>>> dataMap = new LinkedHashMap<String, List<Map<String, Object>>>();
        dataMap.put(sheetName, dataList);
        ExcelUtil.exportExcelMultiSheet(out, dataMap);
    }

    public static void exportExcelMultiSheet(OutputStream out, Map<String, List<Map<String, Object>>> dataMap) throws IOException {
        HSSFWorkbook workbook = new HSSFWorkbook();
        dataMap.forEach((sheetName, dataList) -> {
            HSSFSheet sheet = workbook.createSheet(sheetName);
            sheet.setDefaultRowHeightInPoints(20.0f);
            if (dataList != null && dataList.size() > 0) {
                int i;
                Map<String, CellStyle> styles = ExcelUtil.createStyles((Workbook)workbook);
                HSSFRow row = sheet.createRow(0);
                int index = 0;
                int size = 0;
                for (int i2 = 0; i2 < dataList.size(); ++i2) {
                    if (size >= ((Map)dataList.get(i2)).size()) continue;
                    index = i2;
                    size = ((Map)dataList.get(i2)).size();
                }
                Map map = (Map)dataList.get(index);
                String[] tableHeaders = map.keySet().toArray(new String[0]);
                for (i = 0; i < tableHeaders.length; ++i) {
                    sheet.setColumnWidth(i, 5120);
                    HSSFCell cell = row.createCell(i);
                    cell.setCellValue(tableHeaders[i]);
                    cell.setCellStyle(styles.get("header"));
                }
                for (i = 0; i < dataList.size(); ++i) {
                    Map rowMap = (Map)dataList.get(i);
                    row = sheet.createRow(i + 1);
                    for (int j = 0; j < tableHeaders.length; ++j) {
                        HSSFCell cell = row.createCell(j);
                        Object o = rowMap.get(tableHeaders[j]);
                        ExcelUtil.writeCell((CellBase)cell, o);
                        cell.setCellStyle(styles.get("data2"));
                    }
                }
            }
        });
        workbook.write(out);
        out.flush();
        out.close();
    }

    public static Object getCellValue(Cell cell) {
        if (cell == null) {
            return null;
        }
        Object value = null;
        switch (cell.getCellType()) {
            case STRING: {
                value = cell.getRichStringCellValue().getString();
                break;
            }
            case _NONE: {
                break;
            }
            case NUMERIC: {
                if ("General".equals(cell.getCellStyle().getDataFormatString())) {
                    value = df.format(cell.getNumericCellValue());
                    break;
                }
                if ("m/d/yy".equals(cell.getCellStyle().getDataFormatString())) {
                    value = sdf.format(cell.getDateCellValue());
                    break;
                }
                value = df2.format(cell.getNumericCellValue());
                break;
            }
            case BOOLEAN: {
                value = cell.getBooleanCellValue();
                break;
            }
            case FORMULA: {
                break;
            }
            case BLANK: {
                value = "";
                break;
            }
            case ERROR: {
                break;
            }
        }
        return value;
    }

    private static Map<String, CellStyle> createStyles(Workbook wb) {
        HashMap<String, CellStyle> styles = new HashMap<String, CellStyle>();
        CellStyle style = wb.createCellStyle();
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        style.setBorderRight(BorderStyle.THIN);
        style.setRightBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        style.setBorderLeft(BorderStyle.THIN);
        style.setLeftBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        style.setBorderTop(BorderStyle.THIN);
        style.setTopBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        style.setBorderBottom(BorderStyle.THIN);
        style.setBottomBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        Font dataFont = wb.createFont();
        dataFont.setFontName("Arial");
        dataFont.setFontHeightInPoints((short)10);
        style.setFont(dataFont);
        styles.put("data", style);
        style = wb.createCellStyle();
        style.cloneStyleFrom((CellStyle)styles.get("data"));
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        style.setFillForegroundColor(IndexedColors.GREY_50_PERCENT.getIndex());
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        Font headerFont = wb.createFont();
        headerFont.setFontName("Arial");
        headerFont.setFontHeightInPoints((short)10);
        headerFont.setBold(true);
        headerFont.setColor(IndexedColors.WHITE.getIndex());
        style.setFont(headerFont);
        styles.put("header", style);
        style = wb.createCellStyle();
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        Font totalFont = wb.createFont();
        totalFont.setFontName("Arial");
        totalFont.setFontHeightInPoints((short)10);
        style.setFont(totalFont);
        styles.put("total", style);
        style = wb.createCellStyle();
        style.cloneStyleFrom((CellStyle)styles.get("data"));
        style.setAlignment(HorizontalAlignment.LEFT);
        styles.put("data1", style);
        style = wb.createCellStyle();
        style.cloneStyleFrom((CellStyle)styles.get("data"));
        style.setAlignment(HorizontalAlignment.CENTER);
        styles.put("data2", style);
        style = wb.createCellStyle();
        style.cloneStyleFrom((CellStyle)styles.get("data"));
        style.setAlignment(HorizontalAlignment.RIGHT);
        styles.put("data3", style);
        return styles;
    }

    public static String convertToLetter(int number) {
        if (number < 0) {
            return null;
        }
        ++number;
        StringBuilder sb = new StringBuilder();
        while (number > 0) {
            int mod = (number - 1) % 26;
            sb.insert(0, (char)(mod + 65));
            number = (number - mod) / 26;
        }
        return sb.toString();
    }

    public static XSSFCellStyle createStyle(XSSFWorkbook workbook) {
        return ExcelUtil.createStyle(workbook, null, null, false);
    }

    public static XSSFCellStyle createStyle(XSSFWorkbook workbook, Color bgColor) {
        return ExcelUtil.createStyle(workbook, bgColor, null, false);
    }

    public static XSSFCellStyle createStyle(XSSFWorkbook workbook, Color bgColor, Color fontColor) {
        return ExcelUtil.createStyle(workbook, bgColor, fontColor, false);
    }

    public static XSSFCellStyle createStyle(XSSFWorkbook workbook, Color bgColor, Color fontColor, Boolean fontBlod) {
        XSSFCellStyle cellStyle = workbook.createCellStyle();
        if (bgColor != null) {
            cellStyle.setFillForegroundColor(new XSSFColor(bgColor, (IndexedColorMap)new DefaultIndexedColorMap()));
            cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        }
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        cellStyle.setWrapText(true);
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setBorderRight(BorderStyle.THIN);
        XSSFFont font = workbook.createFont();
        font.setFontName("Arial");
        font.setFontHeightInPoints((short)8);
        font.setBold(false);
        font.setColor(IndexedColors.BLACK.getIndex());
        if (fontBlod != null) {
            font.setBold(fontBlod.booleanValue());
        }
        if (fontColor != null) {
            font.setColor(new XSSFColor(fontColor, (IndexedColorMap)new DefaultIndexedColorMap()));
        }
        cellStyle.setFont((Font)font);
        return cellStyle;
    }

    public static void mergedRegion(XSSFSheet sheet, CellRangeAddress cellAddresses) {
        int firstRow = cellAddresses.getFirstRow();
        int lastRow = cellAddresses.getLastRow();
        int firstColumn = cellAddresses.getFirstColumn();
        int lastColumn = cellAddresses.getLastColumn();
        if (firstRow != lastRow || firstColumn != lastColumn) {
            sheet.addMergedRegion(cellAddresses);
        }
        XSSFCellStyle cellStyle = sheet.getRow(firstRow).getCell(firstColumn).getCellStyle();
        for (int i = firstRow; i < lastRow + 1; ++i) {
            for (int j = firstColumn; j < lastColumn + 1; ++j) {
                XSSFCell cell;
                XSSFRow row = sheet.getRow(i);
                if (row == null) {
                    row = sheet.createRow(i);
                }
                if ((cell = row.getCell(j)) == null) {
                    cell = row.createCell(j);
                }
                cell.setCellStyle((CellStyle)cellStyle);
            }
        }
    }

    private static void createDataByStr(XSSFWorkbook workbook, XSSFSheet sheet, String str) {
        XSSFRow rowindex0;
        String[] split;
        String part1 = str.substring(0, str.indexOf("("));
        String[] part1Array = part1.split("-");
        String index0 = part1Array[0];
        String index1 = part1Array[1];
        String index2 = part1Array[2];
        String index3 = part1Array[3];
        String part2 = str.substring(str.indexOf("(") + 1, str.lastIndexOf(")"));
        String part3 = str.substring(str.indexOf("[") + 1, str.indexOf("]"));
        String[] part3Array = part3.split("\\|");
        String part3Index0 = part3Array[0];
        String part3Index1 = part3Array[1];
        String part3Index2 = part3Array[2];
        Color bgColor = null;
        Color fontColor = null;
        if (part3Index0 != null && !"".equals(part3Index0.trim())) {
            split = part3Index0.split(",");
            bgColor = new Color(Integer.parseInt(split[0]), Integer.parseInt(split[1]), Integer.parseInt(split[2]));
        }
        if (part3Index1 != null && !"".equals(part3Index1.trim())) {
            split = part3Index1.split(",");
            fontColor = new Color(Integer.parseInt(split[0]), Integer.parseInt(split[1]), Integer.parseInt(split[2]));
        }
        if ((rowindex0 = sheet.getRow(Integer.parseInt(index0))) == null) {
            rowindex0 = sheet.createRow(Integer.parseInt(index0));
        }
        XSSFCell row0cell = rowindex0.createCell(Integer.parseInt(index2));
        row0cell.setCellValue(part2);
        row0cell.setCellStyle((CellStyle)ExcelUtil.createStyle(workbook, bgColor, fontColor, Boolean.valueOf(part3Index2)));
        ExcelUtil.mergedRegion(sheet, new CellRangeAddress(Integer.parseInt(index0), Integer.parseInt(index1), Integer.parseInt(index2), Integer.parseInt(index3)));
    }

    public static HeaderCreate createBuilder(XSSFWorkbook workbook, String sheetName) {
        return new HeaderCreate(workbook, workbook.createSheet(sheetName));
    }

    public static HeaderCreate createBuilder(XSSFWorkbook workbook, XSSFSheet sheet) {
        return new HeaderCreate(workbook, sheet);
    }

    public static void writeCell(CellBase cell, Object o) {
        if (o != null) {
            if (o instanceof Number) {
                cell.setCellValue(new Double(o.toString()).doubleValue());
            } else if (o instanceof Boolean) {
                cell.setCellValue(Boolean.parseBoolean(o.toString()));
            } else if (o instanceof Date) {
                cell.setCellValue(DateUtil.getDateFormat((Date)o));
            } else {
                String cellValueStr = o.toString();
                if (cellValueStr.startsWith("FUN=")) {
                    cell.setCellFormula(cellValueStr.substring(4));
                } else if (cellValueStr.startsWith("IMG=")) {
                    try {
                        ExcelUtil.writePicture(cell, cellValueStr.substring(4));
                    }
                    catch (Exception e) {
                        cell.setCellValue(cellValueStr);
                    }
                } else {
                    cell.setCellValue(cellValueStr);
                }
            }
        } else {
            cell.setCellValue("");
        }
    }

    public static void writePicture(CellBase cellBase, String path) throws Exception {
        Sheet sheet = cellBase.getSheet();
        Workbook workbook = sheet.getWorkbook();
        InputStream inputStream = path.startsWith("http") ? new URL(path).openStream() : new FileInputStream(path);
        byte[] bytes = IOUtils.toByteArray((InputStream)inputStream);
        int i1 = workbook.addPicture(bytes, 5);
        inputStream.close();
        CreationHelper helper = workbook.getCreationHelper();
        Drawing drawing = sheet.createDrawingPatriarch();
        ClientAnchor anchor = helper.createClientAnchor();
        anchor.setRow1(cellBase.getRowIndex());
        anchor.setCol1(cellBase.getColumnIndex());
        anchor.setRow2(cellBase.getRowIndex() + 1);
        anchor.setCol2(cellBase.getColumnIndex() + 1);
        drawing.createPicture(anchor, i1);
    }

    public static XSSFWorkbook workbook(File file) {
        XSSFWorkbook workbook;
        if (file.exists()) {
            File fileNew = new File(file.getAbsolutePath().replace(".xlsx", "_back.xlsx"));
            FileUtil.rename((File)file, (String)fileNew.getAbsolutePath(), (boolean)true);
            try {
                workbook = new XSSFWorkbook(fileNew);
            }
            catch (Exception e) {
                workbook = new XSSFWorkbook();
            }
        } else {
            workbook = new XSSFWorkbook();
        }
        return workbook;
    }

    public static XSSFSheet getOrCreateSheet(XSSFWorkbook workbook, String sheetName) {
        XSSFSheet sheet = workbook.getSheet(sheetName);
        if (sheet == null) {
            sheet = workbook.createSheet(sheetName);
        }
        return sheet;
    }

    public static XSSFRow getOrCreateRow(XSSFSheet sheet, int rownum) {
        XSSFRow row = sheet.getRow(rownum);
        if (row == null) {
            row = sheet.createRow(rownum);
        }
        return row;
    }

    public static XSSFCell getOrCreateCell(XSSFRow row, int cellnum) {
        XSSFCell cell = row.getCell(cellnum);
        if (cell == null) {
            cell = row.createCell(cellnum);
        }
        return cell;
    }

    public static class HeaderCreate {
        private XSSFWorkbook workbook;
        private XSSFSheet sheet;

        public HeaderCreate createData(String str) {
            if (str != null && !str.trim().equals("")) {
                ExcelUtil.createDataByStr(this.workbook, this.sheet, str);
            }
            return this;
        }

        public HeaderCreate createRow(int rowNum, Short height) {
            XSSFRow row = this.sheet.createRow(rowNum);
            if (height != null) {
                row.setHeight(height.shortValue());
            }
            return this;
        }

        public HeaderCreate writeData(int startRow, List<Map<String, Object>> dataList) {
            for (int i = 0; i < dataList.size(); ++i) {
                Map<String, Object> rowMap = dataList.get(i);
                XSSFRow row = this.sheet.createRow(i + startRow);
                AtomicInteger index = new AtomicInteger();
                rowMap.forEach((k, o) -> {
                    XSSFCell cell = row.createCell(index.get());
                    ExcelUtil.writeCell((CellBase)cell, o);
                    cell.setCellStyle((CellStyle)ExcelUtil.createStyle(this.workbook, null, null, false));
                    index.getAndIncrement();
                });
            }
            return this;
        }

        public HeaderCreate(XSSFWorkbook workbook, XSSFSheet sheet) {
            this.workbook = workbook;
            this.sheet = sheet;
        }
    }
}

