/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.util;

import cn.acyou.leo.framework.util.DateUtil;
import cn.acyou.leo.framework.util.FileUtil;
import cn.acyou.leo.framework.util.RandomUtil;
import cn.acyou.leo.framework.util.StringUtils;
import com.google.common.collect.Multimap;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.StatusLine;
import org.apache.http.client.CookieStore;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.cookie.Cookie;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.impl.cookie.BasicClientCookie2;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.apache.tomcat.util.http.fileupload.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtil {
    private static final Logger log = LoggerFactory.getLogger(HttpUtil.class);
    private static PoolingHttpClientConnectionManager cm;
    private static IdleConnectionMonitorThread monitor;
    private HttpRequestBase request;
    private final HttpClientBuilder clientBuilder = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)HttpUtil.getHttpClientConnectionManager());
    private final CookieStore cookieStore;
    private final RequestConfig.Builder configBuilder = RequestConfig.custom().setConnectTimeout(5000).setSocketTimeout(10000).setCookieSpec("standard");

    private static PoolingHttpClientConnectionManager getHttpClientConnectionManager() {
        if (cm == null) {
            cm = new PoolingHttpClientConnectionManager();
            cm.setMaxTotal(200);
            cm.setDefaultMaxPerRoute(20);
            SocketConfig config = SocketConfig.custom().setSoTimeout(10000).build();
            cm.setDefaultSocketConfig(config);
            monitor = new IdleConnectionMonitorThread((HttpClientConnectionManager)cm);
            monitor.start();
        }
        return cm;
    }

    private HttpUtil() {
        this.cookieStore = new BasicCookieStore();
    }

    private static List<NameValuePair> convertParameters(Multimap<String, String> params) {
        ArrayList<NameValuePair> pairs = new ArrayList<NameValuePair>(params.size());
        for (Map.Entry entry : params.entries()) {
            pairs.add((NameValuePair)new BasicNameValuePair((String)entry.getKey(), (String)entry.getValue()));
        }
        return pairs;
    }

    public static HttpUtil newInstance() {
        return new HttpUtil();
    }

    public static void shutdown() {
        monitor.shutdown();
        cm.shutdown();
    }

    public static HttpUtil getHttp(String url, Multimap<String, String> paramMap, Map<String, String> headerMap) {
        HttpUtil httpUtil = HttpUtil.newInstance();
        URIBuilder uriBuilder = new URIBuilder(URI.create(url));
        uriBuilder.setCharset(StandardCharsets.UTF_8);
        if (paramMap != null) {
            List<NameValuePair> pairs = HttpUtil.convertParameters(paramMap);
            uriBuilder.setParameters(pairs);
        }
        HttpGet request = new HttpGet(uriBuilder.toString());
        if (headerMap != null && headerMap.size() > 0) {
            for (Map.Entry<String, String> param : headerMap.entrySet()) {
                request.addHeader(param.getKey(), param.getValue());
            }
        }
        httpUtil.request = request;
        return httpUtil;
    }

    public static String get(String url) {
        HttpUtil http = HttpUtil.getHttp(url, null, null);
        return http.execute().getString();
    }

    public static String get(String url, Multimap<String, String> paramMap) {
        HttpUtil http = HttpUtil.getHttp(url, paramMap, null);
        return http.execute().getString();
    }

    public static String get(String url, Multimap<String, String> paramMap, Map<String, String> headerMap) {
        HttpUtil httputil = HttpUtil.getHttp(url, paramMap, headerMap);
        return httputil.execute().getString();
    }

    public static HttpUtil postHttp(String url, Multimap<String, String> paramMap, Map<String, File> fileMap, Map<String, String> headerMap) {
        HttpUtil httpUtil = HttpUtil.newInstance();
        HttpPost request = new HttpPost(url);
        if (fileMap != null && fileMap.size() > 0) {
            MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create().setCharset(StandardCharsets.UTF_8).setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
            for (Map.Entry<String, File> param : fileMap.entrySet()) {
                multipartEntityBuilder.addBinaryBody(param.getKey(), param.getValue());
            }
            if (paramMap != null && paramMap.size() > 0) {
                for (Map.Entry<String, File> param : paramMap.entries()) {
                    multipartEntityBuilder.addTextBody(param.getKey(), (String)((Object)param.getValue()), ContentType.WILDCARD.withCharset(StandardCharsets.UTF_8));
                }
            }
            request.setEntity(multipartEntityBuilder.build());
        } else {
            EntityBuilder entityBuilder = EntityBuilder.create().setContentType(ContentType.APPLICATION_FORM_URLENCODED.withCharset(StandardCharsets.UTF_8)).setContentEncoding(StandardCharsets.UTF_8.name());
            if (paramMap != null && paramMap.size() > 0) {
                List<NameValuePair> nameValuePairs = HttpUtil.convertParameters(paramMap);
                entityBuilder.setParameters(nameValuePairs);
            }
            request.setEntity(entityBuilder.build());
        }
        if (headerMap != null) {
            for (Map.Entry<String, String> param : headerMap.entrySet()) {
                request.addHeader(param.getKey(), param.getValue());
            }
        }
        httpUtil.request = request;
        return httpUtil;
    }

    public static HttpUtil postJsonHttp(String url, String jsonParam, Map<String, String> headerMap) {
        HttpUtil httpUtil = HttpUtil.newInstance();
        HttpPost request = new HttpPost(url);
        if (StringUtils.isNotBlank((CharSequence)jsonParam)) {
            HttpEntity entity = EntityBuilder.create().setText(jsonParam).setContentType(ContentType.APPLICATION_JSON.withCharset(StandardCharsets.UTF_8)).setContentEncoding(StandardCharsets.UTF_8.name()).build();
            request.setEntity(entity);
        }
        if (headerMap != null) {
            for (Map.Entry<String, String> param : headerMap.entrySet()) {
                request.addHeader(param.getKey(), param.getValue());
            }
        }
        httpUtil.request = request;
        return httpUtil;
    }

    public static String post(String url) {
        HttpUtil httputil = HttpUtil.postHttp(url, null, null, null);
        return httputil.execute().getString();
    }

    public static String postJson(String url, String jsonParam, Map<String, String> headerMap) {
        HttpUtil httputil = HttpUtil.postJsonHttp(url, jsonParam, headerMap);
        return httputil.execute().getString();
    }

    public static String post(String url, Multimap<String, String> map) {
        HttpUtil httputil = HttpUtil.postHttp(url, map, null, null);
        return httputil.execute().getString();
    }

    public static String post(String url, Multimap<String, String> paramMap, Map<String, String> headerMap) {
        HttpUtil httputil = HttpUtil.postHttp(url, paramMap, null, headerMap);
        return httputil.execute().getString();
    }

    public static String postFile(String url, Map<String, File> fileMap) {
        HttpUtil httputil = HttpUtil.postHttp(url, null, fileMap, null);
        return httputil.execute().getString();
    }

    public static String postFile(String url, File file) {
        HashMap<String, File> fileMap = new HashMap<String, File>(1);
        fileMap.put(file.getName(), file);
        HttpUtil httputil = HttpUtil.postHttp(url, null, fileMap, null);
        return httputil.execute().getString();
    }

    public static String postFile(String url, Multimap<String, String> paramMap, Map<String, File> fileMap) {
        HttpUtil httputil = HttpUtil.postHttp(url, paramMap, fileMap, null);
        return httputil.execute().getString();
    }

    public static String postFile(String url, Multimap<String, String> paramMap, File file) {
        HashMap<String, File> fileMap = new HashMap<String, File>(1);
        fileMap.put(file.getName(), file);
        HttpUtil httputil = HttpUtil.postHttp(url, paramMap, fileMap, null);
        return httputil.execute().getString();
    }

    public static String postFile(String url, Multimap<String, String> paramMap, List<File> fileList) {
        HashMap<String, File> fileMap = new HashMap<String, File>(fileList.size());
        int length = fileList.size();
        for (int i = 0; i < length; ++i) {
            fileMap.put(fileList.get(i).getName(), fileList.get(i));
        }
        HttpUtil httputil = HttpUtil.postHttp(url, paramMap, fileMap, null);
        return httputil.execute().getString();
    }

    public static HttpUtil putHttp(String url, Multimap<String, String> paramMap, Map<String, File> fileMap, Map<String, String> headerMap) {
        HttpUtil httpUtil = HttpUtil.newInstance();
        HttpPut request = new HttpPut(url);
        if (fileMap != null && fileMap.size() > 0) {
            MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create().setCharset(StandardCharsets.UTF_8).setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
            for (Map.Entry<String, File> param : fileMap.entrySet()) {
                multipartEntityBuilder.addBinaryBody(param.getKey(), param.getValue());
            }
            if (paramMap != null && paramMap.size() > 0) {
                for (Map.Entry<String, File> param : paramMap.entries()) {
                    multipartEntityBuilder.addTextBody(param.getKey(), (String)((Object)param.getValue()), ContentType.WILDCARD.withCharset(StandardCharsets.UTF_8));
                }
            }
            request.setEntity(multipartEntityBuilder.build());
        } else {
            EntityBuilder entityBuilder = EntityBuilder.create().setContentType(ContentType.APPLICATION_FORM_URLENCODED.withCharset(StandardCharsets.UTF_8)).setParameters(new NameValuePair[0]);
            if (paramMap != null && paramMap.size() > 0) {
                List<NameValuePair> nameValuePairs = HttpUtil.convertParameters(paramMap);
                entityBuilder.setParameters(nameValuePairs);
            }
            request.setEntity(entityBuilder.build());
        }
        if (headerMap != null) {
            for (Map.Entry<String, String> param : headerMap.entrySet()) {
                request.addHeader(param.getKey(), param.getValue());
            }
        }
        httpUtil.request = request;
        return httpUtil;
    }

    public static String put(String url) {
        HttpUtil httputil = HttpUtil.putHttp(url, null, null, null);
        return httputil.execute().getString();
    }

    public static String put(String url, Multimap<String, String> map) {
        HttpUtil httputil = HttpUtil.putHttp(url, map, null, null);
        return httputil.execute().getString();
    }

    public static String put(String url, Multimap<String, String> paramMap, Map<String, String> headerMap) {
        HttpUtil httputil = HttpUtil.putHttp(url, paramMap, null, headerMap);
        return httputil.execute().getString();
    }

    public static String putFile(String url, Map<String, File> fileMap) {
        HttpUtil httputil = HttpUtil.postHttp(url, null, fileMap, null);
        return httputil.execute().getString();
    }

    public static HttpUtil deleteHttp(String url, Map<String, String> headerMap) {
        HttpUtil httpUtil = HttpUtil.newInstance();
        HttpDelete request = new HttpDelete(url);
        if (headerMap != null) {
            for (Map.Entry<String, String> param : headerMap.entrySet()) {
                request.addHeader(param.getKey(), param.getValue());
            }
        }
        httpUtil.request = request;
        return httpUtil;
    }

    public static String delete(String url) {
        HttpUtil httputil = HttpUtil.deleteHttp(url, null);
        return httputil.execute().getString();
    }

    public static String delete(String url, Map<String, String> headerMap) {
        HttpUtil httputil = HttpUtil.deleteHttp(url, headerMap);
        return httputil.execute().getString();
    }

    public static InputStream openStream(String url) throws Exception {
        return new URL(url).openStream();
    }

    public static long getContentLength(String url) throws Exception {
        return new URL(url).openConnection().getContentLengthLong();
    }

    public void setSocketTimeout(int socketTimeout) {
        this.configBuilder.setSocketTimeout(socketTimeout);
    }

    public void setConnectTimeout(int connectTimeout) {
        this.configBuilder.setConnectTimeout(connectTimeout);
    }

    public ResponseWrap execute() {
        this.request.setConfig(this.configBuilder.build());
        CloseableHttpClient httpClient = this.clientBuilder.build();
        HttpClientContext context = HttpClientContext.create();
        if (!this.cookieStore.getCookies().isEmpty()) {
            context.setCookieStore(this.cookieStore);
        }
        try {
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)this.request, (HttpContext)context);
            return new ResponseWrap(response, context);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    public void addCookie(String name, String value) {
        this.cookieStore.addCookie((Cookie)new BasicClientCookie2(name, value));
    }

    public void addCookie(Map<String, String> cookieMap) {
        for (Map.Entry<String, String> entry : cookieMap.entrySet()) {
            this.cookieStore.addCookie((Cookie)new BasicClientCookie2(entry.getKey(), entry.getValue()));
        }
    }

    public static void download(String url, String path) throws Exception {
        String name = MessageFormat.format("{0}_{1}.{2}", DateUtil.getCurrentDateFormat("yyyyMMddHHmmss"), RandomUtil.createRandomStr(4), FileUtil.extName(url));
        HttpUtil.download(url, path, name);
    }

    public static void download(String url, String path, @Nullable String imageName) throws Exception {
        URL downloadUrl = new URL(url);
        InputStream inputStream = downloadUrl.openStream();
        File file = new File(path);
        if (!file.exists()) {
            boolean bl = file.mkdirs();
        }
        if (imageName == null || imageName.length() == 0) {
            imageName = url.substring(url.lastIndexOf("/") + 1);
        }
        FileOutputStream out = new FileOutputStream(file + "\\" + imageName);
        IOUtils.copy((InputStream)inputStream, (OutputStream)out);
        inputStream.close();
        out.close();
    }

    public static void main(String[] args) {
        String url = "http://qiniu.acyou.cn/0ecdd8490b7ee4302861b4708a50ac8d.jpg";
        try {
            HttpUtil.download(url, "D:\\images\\");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    static class IdleConnectionMonitorThread
    extends Thread {
        private final HttpClientConnectionManager connMgr;
        private volatile boolean shutdown;

        public IdleConnectionMonitorThread(HttpClientConnectionManager connMgr) {
            this.connMgr = connMgr;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (!this.shutdown) {
                    IdleConnectionMonitorThread idleConnectionMonitorThread = this;
                    synchronized (idleConnectionMonitorThread) {
                        this.wait(5000L);
                        this.connMgr.closeExpiredConnections();
                        this.connMgr.closeIdleConnections(30L, TimeUnit.SECONDS);
                    }
                }
                return;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            this.shutdown = true;
            IdleConnectionMonitorThread idleConnectionMonitorThread = this;
            synchronized (idleConnectionMonitorThread) {
                this.notifyAll();
            }
        }
    }

    public class ResponseWrap {
        private CloseableHttpResponse response;
        private HttpClientContext context;
        private HttpEntity entity;

        public ResponseWrap(CloseableHttpResponse response, HttpClientContext context) {
            this.response = response;
            this.context = context;
            this.entity = response.getEntity();
        }

        public void close() {
            HttpClientUtils.closeQuietly((CloseableHttpResponse)this.response);
        }

        public String getString() {
            return this.getString(StandardCharsets.UTF_8);
        }

        public String getString(Charset defaultCharset) {
            try {
                String string = this.entity == null ? "" : EntityUtils.toString((HttpEntity)this.entity, (Charset)defaultCharset);
                return string;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                HttpClientUtils.closeQuietly((CloseableHttpResponse)this.response);
            }
        }

        public byte[] getByteArray() {
            try {
                byte[] byArray = this.entity == null ? null : EntityUtils.toByteArray((HttpEntity)this.entity);
                return byArray;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                HttpClientUtils.closeQuietly((CloseableHttpResponse)this.response);
            }
        }

        public Header[] getAllHeaders() {
            return this.response.getAllHeaders();
        }

        public Header[] getHeaders(String name) {
            return this.response.getHeaders(name);
        }

        public StatusLine getStatusLine() {
            return this.response.getStatusLine();
        }

        public int getStatusCode() {
            return this.response.getStatusLine().getStatusCode();
        }

        public boolean containsHeader(String name) {
            return this.response.containsHeader(name);
        }

        public List<Cookie> getCookies() {
            return this.context.getCookieStore().getCookies();
        }

        public Cookie getCookie(String name) {
            List cookies = this.context.getCookieStore().getCookies();
            if (cookies != null) {
                for (Cookie cookie : cookies) {
                    if (!name.equals(cookie.getName())) continue;
                    return cookie;
                }
            }
            return null;
        }

        public InputStream getInputStream() {
            try {
                return this.entity == null ? null : this.entity.getContent();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

