/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.util;

import cn.acyou.leo.framework.util.WorkUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONUtil {
    private static final Logger log = LoggerFactory.getLogger(JSONUtil.class);

    public static JSONObject merge(String sourceStr, String targetStr) {
        return WorkUtil.swallowException(() -> {
            JSONObject source = JSON.parseObject((String)sourceStr);
            JSONObject target = JSON.parseObject((String)targetStr);
            return JSONUtil.merge(source, target, true);
        });
    }

    public static JSONObject merge(JSONObject source, JSONObject target) {
        return JSONUtil.merge(source, target, true);
    }

    public static JSONObject merge(JSONObject source, JSONObject target, boolean cover) {
        if (cover) {
            source.putAll((Map)target);
        } else {
            Map innerMap_source = source.getInnerMap();
            Map innerMap_target = target.getInnerMap();
            innerMap_target.forEach((x, v) -> {
                if (!innerMap_source.containsKey(x)) {
                    source.put(x, v);
                }
            });
        }
        return source;
    }

    public static String getByKey(String str, String key) {
        if (StringUtils.isNotBlank((CharSequence)str)) {
            try {
                JSONObject jsonObject = JSON.parseObject((String)str);
                return jsonObject.getString(key);
            }
            catch (Exception e) {
                log.error("\u89e3\u6790JSON\u51fa\u9519", (Throwable)e);
            }
        }
        return null;
    }

    public static <T> T getObjectByKey(String str, String key) {
        if (StringUtils.isNotBlank((CharSequence)str)) {
            try {
                JSONObject jsonObject = JSON.parseObject((String)str);
                return (T)jsonObject.get((Object)key);
            }
            catch (Exception e) {
                log.info("\u83b7\u53d6\u5c5e\u6027\u51fa\u9519", (Throwable)e);
            }
        }
        return null;
    }

    public static String setByKey(String str, String key, Object val) {
        JSONObject obj = new JSONObject();
        if (StringUtils.isNotBlank((CharSequence)str)) {
            try {
                obj = JSON.parseObject((String)str);
            }
            catch (Exception e) {
                log.error("\u89e3\u6790JSON\u51fa\u9519", (Throwable)e);
            }
        }
        obj.put(key, val);
        return obj.toJSONString();
    }

    public static String getJsonPJsonStr(String jsonpStr) {
        int startIndex = jsonpStr.indexOf("(");
        int endIndex = jsonpStr.lastIndexOf(")");
        return jsonpStr.substring(startIndex + 1, endIndex);
    }

    public static JSONObject getJsonPJsonObject(String jsonpStr) {
        String jsonPJsonStr = JSONUtil.getJsonPJsonStr(jsonpStr);
        return JSON.parseObject((String)jsonPJsonStr);
    }

    public static JSONArray getJsonPJsonArray(String jsonpStr) {
        String jsonPJsonStr = JSONUtil.getJsonPJsonStr(jsonpStr);
        return JSON.parseArray((String)jsonPJsonStr);
    }
}

