/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.util;

import java.io.IOException;
import java.net.InetAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkUtil {
    private static final Logger log = LoggerFactory.getLogger(NetworkUtil.class);

    public static boolean isReachable(String ipOrHost) {
        int timeOut = 1000;
        try {
            return InetAddress.getByName(ipOrHost).isReachable(timeOut);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static boolean notReachable(String ip) {
        return !NetworkUtil.isReachable(ip);
    }

    public static void main(String[] args) {
        System.out.println(NetworkUtil.isReachable("192.168.1.120"));
        System.out.println(NetworkUtil.isReachable("192.168.12.120"));
    }
}

