/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.util;

import cn.acyou.leo.framework.util.Assert;
import cn.acyou.leo.framework.util.StringUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NumberUtil {
    private static final Logger log = LoggerFactory.getLogger(NumberUtil.class);
    public static int UNIT_STEP = 4;
    public static String[] CN_UNITS = new String[]{"\u4e2a", "\u5341", "\u767e", "\u5343", "\u4e07", "\u5341", "\u767e", "\u5343", "\u4ebf", "\u5341", "\u767e", "\u5343", "\u4e07"};
    public static String[] CN_CHARS = new String[]{"\u96f6", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d"};

    public static String getCnNum(int srcNum) {
        StringBuilder descnnum = new StringBuilder();
        if (srcNum <= 0) {
            descnnum = new StringBuilder("\u96f6");
        } else {
            while (srcNum > 0) {
                int singleDigit = srcNum % 10;
                descnnum.insert(0, CN_CHARS[singleDigit]);
                srcNum /= 10;
            }
        }
        return descnnum.toString();
    }

    private static String cvt(String num, boolean isColloquial) {
        String[] integerResult;
        StringBuilder strs = new StringBuilder(32);
        String[] splitNum = num.split("\\.");
        int integer = Integer.parseInt(splitNum[0]);
        int decimal = Integer.parseInt(splitNum[1]);
        for (String str1 : integerResult = NumberUtil.convert(integer, isColloquial)) {
            strs.append(str1);
        }
        if (decimal == 0) {
            return strs.toString();
        }
        String decimalResult = NumberUtil.getCnNum(decimal);
        strs.append("\u70b9");
        strs.append(decimalResult);
        return strs.toString();
    }

    public static String[] convert(long num, boolean isColloquial) {
        if (num < 10L) {
            return new String[]{CN_CHARS[(int)num]};
        }
        char[] chars = String.valueOf(num).toCharArray();
        if (chars.length > CN_UNITS.length) {
            return new String[0];
        }
        boolean isLastUnitStep = false;
        ArrayList<String> cnchars = new ArrayList<String>(chars.length * 2);
        for (int pos = chars.length - 1; pos >= 0; --pos) {
            boolean isUnitStep;
            char ch = chars[pos];
            String cnChar = CN_CHARS[ch - 48];
            int unitPos = chars.length - pos - 1;
            String cnUnit = CN_UNITS[unitPos];
            boolean isZero = ch == '0';
            boolean isZeroLow = pos + 1 < chars.length && chars[pos + 1] == '0';
            boolean bl = isUnitStep = unitPos >= UNIT_STEP && unitPos % UNIT_STEP == 0;
            if (isUnitStep && isLastUnitStep) {
                int size = cnchars.size();
                cnchars.remove(size - 1);
                if (!CN_CHARS[0].equals(cnchars.get(size - 2))) {
                    cnchars.add(CN_CHARS[0]);
                }
            }
            if (isUnitStep || !isZero) {
                cnchars.add(cnUnit);
                isLastUnitStep = isUnitStep;
            }
            if (isZero && (isZeroLow || isUnitStep)) continue;
            cnchars.add(cnChar);
            isLastUnitStep = false;
        }
        Collections.reverse(cnchars);
        int chSize = cnchars.size();
        String chEnd = (String)cnchars.get(chSize - 1);
        if (CN_CHARS[0].equals(chEnd) || CN_UNITS[0].equals(chEnd)) {
            cnchars.remove(chSize - 1);
        }
        if (isColloquial) {
            String chFirst = (String)cnchars.get(0);
            String chSecond = (String)cnchars.get(1);
            if (chFirst.equals(CN_CHARS[1]) && chSecond.startsWith(CN_UNITS[1])) {
                cnchars.remove(0);
            }
        }
        return cnchars.toArray(new String[0]);
    }

    public static void main(String[] args) {
        System.out.println(NumberUtil.toUpperCaseAndColloquial(10));
        System.out.println(NumberUtil.toUpperCaseAndColloquial(22));
    }

    private static String toUpperCase(int num) {
        return NumberUtil.cvt(String.valueOf(num), false);
    }

    private static String toUpperCaseAndColloquial(int num) {
        return NumberUtil.cvt(String.valueOf(num), true);
    }

    public static BigDecimal add(String ... values) {
        if (ArrayUtils.isEmpty((Object[])values)) {
            return BigDecimal.ZERO;
        }
        String value = values[0];
        BigDecimal result = NumberUtil.toBigDecimal(value);
        for (int i = 1; i < values.length; ++i) {
            value = values[i];
            if (!StringUtils.isNotBlank((CharSequence)value)) continue;
            result = result.add(NumberUtil.toBigDecimal(value));
        }
        return result;
    }

    public static BigDecimal sub(String ... values) {
        if (ArrayUtils.isEmpty((Object[])values)) {
            return BigDecimal.ZERO;
        }
        String value = values[0];
        BigDecimal result = NumberUtil.toBigDecimal(value);
        for (int i = 1; i < values.length; ++i) {
            value = values[i];
            if (!StringUtils.isNotBlank((CharSequence)value)) continue;
            result = result.subtract(NumberUtil.toBigDecimal(value));
        }
        return result;
    }

    public static BigDecimal mul(String ... values) {
        if (ArrayUtils.isEmpty((Object[])values)) {
            return BigDecimal.ZERO;
        }
        BigDecimal result = new BigDecimal(values[0]);
        for (int i = 1; i < values.length; ++i) {
            result = result.multiply(new BigDecimal(values[i]));
        }
        return result;
    }

    public static BigDecimal div(String v1, String v2) {
        return NumberUtil.div(NumberUtil.toBigDecimal(v1), NumberUtil.toBigDecimal(v2), 2, RoundingMode.FLOOR);
    }

    public static BigDecimal div(BigDecimal v1, BigDecimal v2, int scale, RoundingMode roundingMode) {
        Assert.notNull(v2, "Divisor must be not null !");
        if (null == v1) {
            return BigDecimal.ZERO;
        }
        if (scale < 0) {
            scale = -scale;
        }
        return v1.divide(v2, scale, roundingMode);
    }

    public static BigDecimal toBigDecimal(String number) {
        try {
            number = NumberUtil.parseNumber(number).toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return StringUtils.isBlank((CharSequence)number) ? BigDecimal.ZERO : new BigDecimal(number);
    }

    public static Number parseNumber(String numberStr) throws NumberFormatException {
        try {
            return NumberFormat.getInstance().parse(numberStr);
        }
        catch (ParseException e) {
            NumberFormatException nfe = new NumberFormatException(e.getMessage());
            nfe.initCause(e);
            throw nfe;
        }
    }

    public static Integer parseInt(String s) {
        try {
            return Integer.valueOf(s);
        }
        catch (Exception e) {
            log.error("\u8f6c\u6362\u6570\u5b57\u5931\u8d25\uff1a{}", (Object)s);
            return null;
        }
    }

    public static Long parseLong(String s) {
        try {
            return Long.valueOf(s);
        }
        catch (Exception e) {
            log.error("\u8f6c\u6362\u6570\u5b57\u5931\u8d25\uff1a{}", (Object)s);
            return null;
        }
    }
}

