/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.util;

import cn.acyou.leo.framework.util.StringUtils;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;

public class RSAUtils {
    private static final int KEY_SIZE = 2048;

    public static Map<Integer, String> genKeyPair() throws NoSuchAlgorithmException {
        HashMap<Integer, String> keyMap = new HashMap<Integer, String>();
        KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance("RSA");
        keyPairGen.initialize(2048, new SecureRandom());
        KeyPair keyPair = keyPairGen.generateKeyPair();
        RSAPrivateKey privateKey = (RSAPrivateKey)keyPair.getPrivate();
        RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
        String publicKeyString = Base64.getEncoder().encodeToString(publicKey.getEncoded());
        String privateKeyString = Base64.getEncoder().encodeToString(privateKey.getEncoded());
        keyMap.put(0, publicKeyString);
        keyMap.put(1, privateKeyString);
        return keyMap;
    }

    public static String encrypt(String str, String publicKey) throws Exception {
        byte[] decoded = Base64.getDecoder().decode(publicKey);
        RSAPublicKey pubKey = (RSAPublicKey)KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(decoded));
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(1, pubKey);
        return Base64.getEncoder().encodeToString(cipher.doFinal(str.getBytes(StandardCharsets.UTF_8)));
    }

    public static String decrypt(String str, String privateKey) throws Exception {
        byte[] inputByte = Base64.getDecoder().decode(str);
        byte[] decoded = Base64.getDecoder().decode(privateKey);
        RSAPrivateKey priKey = (RSAPrivateKey)KeyFactory.getInstance("RSA").generatePrivate(new PKCS8EncodedKeySpec(decoded));
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(2, priKey);
        return new String(cipher.doFinal(inputByte));
    }

    public static void printFormatPublicKey(String key) {
        ArrayList<String> contentList = new ArrayList<String>();
        contentList.add("-----BEGIN PUBLIC KEY-----");
        contentList.addAll(StringUtils.splitByLength(key, 64));
        contentList.add("-----END PUBLIC KEY-----");
        for (String s : contentList) {
            System.out.println(s);
        }
    }

    public static void printFormatPrivateKey(String key) {
        ArrayList<String> contentList = new ArrayList<String>();
        contentList.add("-----BEGIN PRIVATE KEY-----");
        contentList.addAll(StringUtils.splitByLength(key, 64));
        contentList.add("-----END PRIVATE KEY-----");
        for (String s : contentList) {
            System.out.println(s);
        }
    }

    public static void mai2n(String[] args) throws Exception {
        String data = "ODZRohQ7H8+a24N2kVu1205HF6SWZFMr23OWF9hGu9CHDYHusuawM5eXTqBVVUR2CmIq2dksPzsUmg6fylluHeL+Xa1snb3E0ZEq7lqv+8Eapm56DmWWijuL4Qx43PDjgdGLh22rJmlzwrse2rqvGjKwuAIrL7u8LwXhuIEbnoxfTyzU0hJtHZyhv+y7uoPfU+/RvCXRk9HzLTI1r+0Eqx12VwtaqoYbvLJc7dAegbMqKHcLZI0l/bVbzSWNwsrph86BfFB7P3POxYoe2LfX/waqFSPBfzUFvzzj0LGwxD/sEbGl22vUBzRoscfj2VDgVsSFnJr4c4g9QEWMxBj+Zw==";
        String privateKey = "MIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQCKj3oOuducNXpKQMtNtg2bsDaQ5EYEhdEvX9y22nvxurjpZKsY3c/ZPQz/aluJCMjTQIkiDAXE6S3DoNMBEXntwc5kCBwLkByvWvKMIUVU/LwYHgY6ZBn5pFA8hEiqrl54fAos5471LqGCgYzRKMMB+11WIeR3BFH02sRFGdLKLTKta3EXDPS1hY3X+yvnL0EqX+G9t9Pd4WPu1MKnHH9+6uHi9cq0uHz5+GQX+DIbNFW8YB5YIolYT86GZgrpiEfa+0WYLrbLfAN4ImPU14N0HgnQ4bi0iadsyC/sMjx++hAPb7ZYkWSqs+aSLaa4ihsFjX9+aRKSSCJ1Vo4JHgbBAgMBAAECggEAI/cX9IiTk1liM7Hb04EEyTuU/kjyT6w4XvagAKp3b4hLBPHHY333vGiXXhjKR6iLECJ5Negu+yyXX2b4Phe+MVOT8e0U8n9morGVsX/VUjkDzbLFZRSklWLsHLktb3gxN07jCULVnZiL/acI2SWecH5BfODxP19UspyyQ0lvqGBupTL5R0yOBTIjJMSzOPca8yvd50wQxHokXzFlGw14lp8sb7dB0JcIVCxMgDtqPjLheWdAihD4d38Jso1659O53qQk6sQ+M1cWmWTnzBMUGagykuZJEF8a0D5+Dgm4x1VTP+7dKALBbnDZ/vNkN8QW8gLo8m3sdVIwdFVwO8RyvQKBgQDR4W2O0UOugsfl3S2FQETu9Mj7laMfZ+jrb9HH1a4KCxoQuHC6cE6eQNCFLsBbxGwGVBLO2KtkOGyqQ2tWakUCI7pnxcy5VEL8QHQenqW+xhdblmjFioBwZZHduztPa4+WqMC/bSzi4C8FJTr31oLmAfSGbltc1fwcra784GWvewKBgQCpAgYQOnjJce35QuAxDGbDZ4ZrTvQAlgLunILoVMGUjrZFA/+s7jb1zjMxS/iy/pfL/pnw/B/WVefox10LQB9TGp9OYBFIR+8nNGCdO+4TKi0z6HEnrPXjnvKQyZiCyIe0sMxqDAFbYgOSfwBFGbw4yjPX+s5ikhMUiQG/ZtzP8wKBgQCtw1iEXIcPjWFY0ySj5NDtkaZwfLQABXSWsA5bx3J/CC/9VeamxOKiLQE2sr05fMb++k5UCJjlsb1tvcG5WuRlYBUtY1sauUN4OxioXSrWZoTiJAX8Pq4V4FHC5Qe2ulO4JWDnW8lE0Ny9AtTuaiAXs9iyD93+X3+KctWksVgezwKBgDwUzhcC0mG6sMDF93E4WWfp661GOhPjQFOXLCpvxwmK2l0amM/fN4aWsTg7K8RmIYyRjCRRXPgTPghQp1ESkJA4jJ2OJVauy+QCCL6cyXviqIMlhOR35knu/YhfQmpr42Jm36RrdCgKZf60S2JFTdZae6eyL6B3EXVhZ0+lv6XlAoGBAKU8wFSyBXxrAwQwmjzq1NOOBeqzQID04tTdtwW8rho8T1QNpivAgpzu3YbBXl2eImbdWqP3as8oaNRbxbT5B2Pby/qPo2iUqKJTfD+ruqjH2QAUw3QLQEOxLA8WFHuBxA56cqbBWtP6heYwZBK/bqyFMka2Fc6o3I8SCg2lmhJw";
        String s = RSAUtils.decrypt(data, privateKey);
        System.out.println(s);
    }

    public static void main(String[] args) throws Exception {
        long temp = System.currentTimeMillis();
        Map<Integer, String> keyMap = RSAUtils.genKeyPair();
        System.out.println("\u516c\u94a5:\r\n" + keyMap.get(0));
        RSAUtils.printFormatPublicKey(keyMap.get(0));
        System.out.println("\u79c1\u94a5:\r\n" + keyMap.get(1));
        RSAUtils.printFormatPrivateKey(keyMap.get(1));
        System.out.println("\u751f\u6210\u5bc6\u94a5\u6d88\u8017\u65f6\u95f4:" + (double)(System.currentTimeMillis() - temp) / 1000.0 + "\u79d2");
        String message = "RSA\u6d4b\u8bd5---->";
        System.out.println("\u539f\u6587:" + message);
        temp = System.currentTimeMillis();
        String messageEn = RSAUtils.encrypt(message, keyMap.get(0));
        System.out.println("\u5bc6\u6587:" + messageEn);
        System.out.println("\u52a0\u5bc6\u6d88\u8017\u65f6\u95f4:" + (double)(System.currentTimeMillis() - temp) / 1000.0 + "\u79d2");
        temp = System.currentTimeMillis();
        String messageDe = RSAUtils.decrypt(messageEn, keyMap.get(1));
        System.out.println("\u89e3\u5bc6:" + messageDe);
        System.out.println("\u89e3\u5bc6\u6d88\u8017\u65f6\u95f4:" + (double)(System.currentTimeMillis() - temp) / 1000.0 + "\u79d2");
    }
}

