/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.util;

import cn.acyou.leo.framework.util.RegexUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.lang.Nullable;

public class StringUtils
extends org.apache.commons.lang3.StringUtils {
    public static final String SPACE = " ";
    public static final String EMPTY = "";
    public static final String COMMA = ",";
    public static final String DOT = ".";
    public static final String NEW_LINE = "\r\n";
    private static final String[] CHINESE_NUMBER = new String[]{"\u96f6", "\u58f9", "\u8d30", "\u53c1", "\u8086", "\u4f0d", "\u9646", "\u67d2", "\u634c", "\u7396"};
    private static final String[] CHINESE_NUMBER_UNIT = new String[]{"", "\u62fe", "\u4f70", "\u4edf", "\u4e07", "\u62fe", "\u4f70", "\u4edf", "\u4ebf", "\u62fe", "\u4f70", "\u4edf"};
    private static final String[] CHINESE_MONEY_UNIT = new String[]{"\u5706", "\u89d2", "\u5206"};

    public static String concatLengthChar(int length, char character) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            sb.append(character);
        }
        return sb.toString();
    }

    public static String joinOnComma(Iterable<?> iterable) {
        return org.apache.commons.lang3.StringUtils.join(iterable.iterator(), (String)COMMA);
    }

    public static String formatTemplate(String templateStr, String ... params) {
        List<String> matchStr = RegexUtil.getMatchStr(templateStr, "\\{(.+?)\\}");
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        for (int i = 0; i < matchStr.size(); ++i) {
            String varStr = matchStr.get(i);
            paramsMap.put(varStr.substring(1, varStr.length() - 1), params[i]);
        }
        return StringUtils.formatTemplate(templateStr, paramsMap);
    }

    public static String formatTemplate(String templateStr, Map<String, String> paramsMap) {
        String templateContent = templateStr;
        Set<Map.Entry<String, String>> entrySet = paramsMap.entrySet();
        for (Map.Entry<String, String> entry : entrySet) {
            if (entry.getValue() == null || templateContent.indexOf(entry.getKey()) <= 0) continue;
            templateContent = templateContent.replace("{" + entry.getKey() + "}", entry.getValue());
        }
        return templateContent;
    }

    public static String toStr(Object obj) {
        String str = EMPTY;
        if (obj != null) {
            str = obj.toString();
        }
        return str;
    }

    public static String nullAsDashed(String str) {
        if (str == null) {
            return "-";
        }
        return str;
    }

    public static String isBlank(Object value, Object defaultValue) {
        if (StringUtils.isBlank(value)) {
            return defaultValue.toString();
        }
        return value.toString();
    }

    public static boolean isNotBlank(Object obj) {
        return obj != null && StringUtils.isNotBlank((CharSequence)obj.toString());
    }

    public static String isNotBlank(Object obj, Object defaultValue) {
        return StringUtils.isNotBlank(obj) ? obj.toString() : defaultValue.toString();
    }

    public static boolean isBlank(Object obj) {
        return obj == null || StringUtils.isBlank((CharSequence)obj.toString());
    }

    public static String[] strLengthSplit(String sourceStr, int length) {
        if (StringUtils.isBlank((CharSequence)sourceStr)) {
            return new String[]{EMPTY, EMPTY};
        }
        int sp = length * 2;
        int indexCount = 0;
        int index = 0;
        char[] chars = sourceStr.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            indexCount = RegexUtil.isChinese(c) ? (indexCount += 2) : ++indexCount;
            if (indexCount <= sp) continue;
            index = i;
            break;
        }
        String[] returnStr = new String[]{EMPTY, EMPTY};
        if (index > 0) {
            returnStr[0] = sourceStr.substring(0, index);
            returnStr[1] = sourceStr.substring(index);
        } else {
            returnStr[0] = sourceStr;
            returnStr[1] = EMPTY;
        }
        return returnStr;
    }

    public static boolean isHttpUrl(String text) {
        return text.startsWith("http://") || text.startsWith("https://");
    }

    public static String hide(CharSequence str, int startInclude, int endExclude) {
        return StringUtils.replace(str, startInclude, endExclude, '*');
    }

    public static String replace(CharSequence str, int startInclude, int endExclude, char replacedChar) {
        if (str == null || str.length() == 0) {
            return StringUtils.str(str);
        }
        int strLength = str.length();
        if (startInclude > strLength) {
            return StringUtils.str(str);
        }
        if (endExclude > strLength) {
            endExclude = strLength;
        }
        if (startInclude > endExclude) {
            return StringUtils.str(str);
        }
        char[] chars = new char[strLength];
        for (int i = 0; i < strLength; ++i) {
            chars[i] = i >= startInclude && i < endExclude ? replacedChar : str.charAt(i);
        }
        return new String(chars);
    }

    public static String str(CharSequence cs) {
        return null == cs ? null : cs.toString();
    }

    public static List<String> splitByLength(String sourStr, int length) {
        return StringUtils.splitByLength(new ArrayList<String>(), sourStr, length);
    }

    private static List<String> splitByLength(List<String> container, String sourStr, int length) {
        if (sourStr != null && sourStr.length() > 0) {
            if (sourStr.length() < length) {
                container.add(sourStr);
                return container;
            }
            String str0 = sourStr.substring(0, length);
            String str1 = sourStr.substring(length);
            container.add(str0);
            return StringUtils.splitByLength(container, str1, length);
        }
        return container;
    }

    public static void println(Object obj) {
        if (obj == null) {
            System.out.println("null");
            return;
        }
        if (obj instanceof CharSequence) {
            System.out.println(obj);
            return;
        }
        if (obj.getClass().isArray()) {
            Arrays.stream((Object[])obj).forEach(System.out::println);
            return;
        }
        if (obj instanceof Collection) {
            ((Collection)obj).forEach(System.out::println);
            return;
        }
        if (obj instanceof Map) {
            ((Map)obj).forEach((k, v) -> System.out.println(k + ":" + v));
            return;
        }
        System.out.println(obj);
    }

    public static boolean containChinese(String str) {
        Pattern p = Pattern.compile("[\u4e00-\u9fa5]");
        Matcher m = p.matcher(str);
        return m.find();
    }

    public static boolean isAllChinese(String name) {
        boolean res = true;
        char[] cTemp = name.toCharArray();
        for (int i = 0; i < name.length(); ++i) {
            if (StringUtils.containChinese(String.valueOf(cTemp[i]))) continue;
            res = false;
            break;
        }
        return res;
    }

    public static void main(String[] args) {
        String templateStr = "{\u59d3\u540d}\u4eca\u5e74{\u5c81}\u5566\uff01";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("\u59d3\u540d", "\u738b\u4e8c\u5c0f");
        paramMap.put("\u5c81", "3");
        System.out.println(StringUtils.formatTemplate(templateStr, paramMap));
    }

    public static boolean hasLength(@Nullable CharSequence str) {
        return str != null && str.length() > 0;
    }

    public static boolean hasLength(@Nullable String str) {
        return str != null && !str.isEmpty();
    }

    public static boolean hasText(@Nullable CharSequence str) {
        return str != null && str.length() > 0 && StringUtils.containsText(str);
    }

    public static boolean hasText(@Nullable String str) {
        return str != null && !str.isEmpty() && StringUtils.containsText(str);
    }

    private static boolean containsText(CharSequence str) {
        int strLen = str.length();
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static String escapeSql(String text) {
        if (StringUtils.isNotBlank((CharSequence)text)) {
            return text.replace("'", "\\'").replace("\r", "\\r").replace("\n", "\\n");
        }
        return text;
    }

    public static String toChineseMoney(BigDecimal sourceMoney) {
        int number;
        if (new BigDecimal("1000000000000").compareTo(sourceMoney) <= 0 && BigDecimal.ZERO.compareTo(sourceMoney) >= 0) {
            throw new RuntimeException("\u652f\u6301\u8f6c\u6362\u7684\u91d1\u989d\u8303\u56f4\u4e3a0~1\u4e07\u4ebf");
        }
        StringBuilder sb = new StringBuilder();
        BigDecimal intPart = sourceMoney.setScale(0, RoundingMode.DOWN);
        BigDecimal decimalPart = sourceMoney.subtract(intPart).multiply(new BigDecimal(100)).setScale(0, RoundingMode.DOWN);
        if (intPart.compareTo(BigDecimal.ZERO) > 0) {
            int number2;
            int i;
            String intPartNumberString = intPart.toPlainString();
            int length = intPartNumberString.length();
            int zeroCount = 0;
            for (i = length - 1; i >= 0 && (number2 = Integer.parseInt(String.valueOf(intPartNumberString.charAt(i)))) == 0; --i) {
                ++zeroCount;
            }
            for (i = 0; i < length && i + zeroCount != length; ++i) {
                number2 = Integer.parseInt(String.valueOf(intPartNumberString.charAt(i)));
                String chineseNumber = CHINESE_NUMBER[number2];
                String chineseNumberUnit = CHINESE_NUMBER_UNIT[length - i - 1];
                sb.append(chineseNumber).append(chineseNumberUnit);
            }
            sb.append(CHINESE_MONEY_UNIT[0]);
        } else {
            sb.append(CHINESE_NUMBER[0]).append(CHINESE_MONEY_UNIT[0]);
        }
        if (decimalPart.compareTo(new BigDecimal(10)) >= 0) {
            String fen;
            String jiao = decimalPart.toPlainString();
            number = Integer.parseInt(String.valueOf(jiao.charAt(0)));
            if (number != 0) {
                String chineseNumber = CHINESE_NUMBER[number];
                sb.append(chineseNumber).append(CHINESE_MONEY_UNIT[1]);
            }
            if ((number = Integer.parseInt(String.valueOf((fen = decimalPart.toPlainString()).charAt(1)))) != 0) {
                String chineseNumber = CHINESE_NUMBER[number];
                sb.append(chineseNumber).append(CHINESE_MONEY_UNIT[2]);
            }
        } else if (decimalPart.compareTo(BigDecimal.ZERO) > 0) {
            String fen = decimalPart.toPlainString();
            number = Integer.parseInt(String.valueOf(fen.charAt(0)));
            if (number != 0) {
                String chineseNumber = CHINESE_NUMBER[number];
                sb.append(chineseNumber).append(CHINESE_MONEY_UNIT[2]);
            }
        } else {
            sb.append("\u6574");
        }
        return sb.toString();
    }
}

