/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.util;

import cn.acyou.leo.framework.commons.AsyncManager;
import cn.acyou.leo.framework.constant.CommonErrorEnum;
import cn.acyou.leo.framework.exception.ServiceException;
import cn.acyou.leo.framework.util.function.CallTask;
import cn.acyou.leo.framework.util.function.Task;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StopWatch;

public class WorkUtil {
    private static final Logger log = LoggerFactory.getLogger(WorkUtil.class);

    public static <T> T doCallWork(long timeout, TimeUnit unit, Supplier<T> supplier) {
        long startTime = System.nanoTime();
        long rem = unit.toNanos(timeout);
        do {
            try {
                T t = supplier.get();
                if (t != null) {
                    return t;
                }
            }
            catch (Exception ex) {
                if (rem <= 0L) continue;
                try {
                    Thread.sleep(Math.min(TimeUnit.NANOSECONDS.toMillis(rem) + 1L, 100L));
                }
                catch (Exception e) {
                    log.error(e.getMessage());
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        } while ((rem = unit.toNanos(timeout) - (System.nanoTime() - startTime)) > 0L);
        return null;
    }

    public static void tryRun(Task task) {
        try {
            task.run();
        }
        catch (Exception e) {
            WorkUtil.printFirstStack(e);
        }
    }

    public static void printFirstStack(Throwable e) {
        String reason = e.getMessage();
        StackTraceElement[] stackTrace = e.getStackTrace();
        if (stackTrace != null && stackTrace.length > 0) {
            StackTraceElement stackTraceElement = stackTrace[0];
            reason = reason + " ERROR MSG: " + stackTraceElement.getClassName() + "|" + stackTraceElement.getMethodName() + ":" + stackTraceElement.getLineNumber();
        }
        log.error(reason);
    }

    public static void trySleep5000() {
        WorkUtil.trySleep(5000L);
    }

    public static void trySleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
    }

    public static <T> T doRetryWork(int times, CallTask<T> task) {
        for (int currentTime = 0; currentTime < times; ++currentTime) {
            try {
                return task.run();
            }
            catch (Exception e) {
                log.error("doRetryWorkError \u6267\u884c\u4efb\u52a1\u51fa\u9519", (Throwable)e);
                WorkUtil.trySleep(2000L);
                continue;
            }
        }
        return null;
    }

    public static void doRetryWork(int times, Task task) {
        for (int currentTime = 0; currentTime < times; ++currentTime) {
            try {
                task.run();
                return;
            }
            catch (Exception e) {
                log.error("doRetryWorkError \u6267\u884c\u4efb\u52a1\u51fa\u9519", (Throwable)e);
                WorkUtil.trySleep(2000L);
                continue;
            }
        }
    }

    public static void doRetryWorkGradually(int times, Task task) {
        WorkUtil.doRetryWorkGradually(1, times, task);
    }

    private static void doRetryWorkGradually(int currentTimes, int times, Task task) {
        AsyncManager.schedule(() -> {
            if (currentTimes <= times) {
                try {
                    task.run();
                }
                catch (Exception e) {
                    log.error("doRetryWorkGradually \u6267\u884c\u4efb\u52a1\u51fa\u9519", (Throwable)e);
                    WorkUtil.doRetryWorkGradually(currentTimes + 1, times, task);
                }
            }
        }, WorkUtil.getGraduallyRule(currentTimes), TimeUnit.SECONDS);
    }

    private static int getGraduallyRule(int currentTimes) {
        if (currentTimes <= 1) {
            return 1;
        }
        if (currentTimes == 2) {
            return 15;
        }
        if (currentTimes == 3) {
            return 15;
        }
        if (currentTimes == 4) {
            return 30;
        }
        if (currentTimes == 5) {
            return 180;
        }
        if (currentTimes == 6) {
            return 600;
        }
        return 600;
    }

    public static void watch(Task task) {
        StopWatch stopWatch = new StopWatch();
        log.info("\u4efb\u52a1\u8017\u65f6\u76d1\u63a7 \u5f00\u59cb -> ...");
        stopWatch.start();
        task.run();
        stopWatch.stop();
        log.info("\u4efb\u52a1\u8017\u65f6\u76d1\u63a7 \u7ed3\u675f <- \u8017\u65f6\uff1a{}ms", (Object)stopWatch.getTotalTimeMillis());
    }

    public static <T> T doWaitWork(long waitTimeout, long interval, CallTask<T> task) {
        long deadline = System.currentTimeMillis() + waitTimeout;
        if (waitTimeout <= 0L) {
            return task.run();
        }
        try {
            do {
                T r;
                if ((r = task.run()) != null) {
                    return r;
                }
                WorkUtil.trySleep(Math.min(interval, deadline - System.currentTimeMillis()));
            } while (System.currentTimeMillis() < deadline);
        }
        catch (Exception e) {
            log.error("\u5185\u90e8\u65b9\u6cd5\u53d1\u751f\u9519\u8bef", (Throwable)e);
            return null;
        }
        throw new ServiceException(CommonErrorEnum.NO_WAIT_RESULT_ERROR);
    }

    public static <T> T swallowException(CallTask<T> callTask) {
        try {
            return callTask.run();
        }
        catch (Exception e) {
            WorkUtil.printFirstStack(e);
            return null;
        }
    }
}

